/*
 * Decompiled with CFR 0.152.
 */
package top.yqingyu.httpserver.compoment;

import com.alibaba.fastjson2.JSON;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import top.yqingyu.common.qydata.ConcurrentDataSet;
import top.yqingyu.common.qydata.DataMap;
import top.yqingyu.common.utils.ArrayUtil;
import top.yqingyu.common.utils.LocalDateTimeUtil;
import top.yqingyu.httpserver.compoment.ContentType;
import top.yqingyu.httpserver.compoment.Cookie;
import top.yqingyu.httpserver.compoment.HttpAction;
import top.yqingyu.httpserver.compoment.HttpVersion;

public class Response
implements HttpAction {
    public static final Response $404_NOT_FOUND = new Response().setStatue_code("404").setHttpVersion(HttpVersion.V_1_1).setString_body("\u6728\u6709\u8d44\u6e90\u5566 ^ \u03a9 ^").putHeaderContentType(ContentType.TEXT_PLAIN).setAssemble(true);
    public static final Response $413_ENTITY_LARGE = new Response().setStatue_code("413").setHttpVersion(HttpVersion.V_1_1).setString_body("413 Request Entity Too Large").putHeaderContentType(ContentType.TEXT_PLAIN).setAssemble(true);
    public static final Response $100_CONTINUE = new Response().setStatue_code("100").setHttpVersion(HttpVersion.V_1_1).setAssemble(true);
    public static final Response $400_BAD_REQUEST = new Response().setStatue_code("400").setHttpVersion(HttpVersion.V_1_1).setString_body("400 Bad Request").putHeaderContentType(ContentType.TEXT_PLAIN).setAssemble(true);
    public static final Response $401_BAD_REQUEST = new Response().setStatue_code("400").setHttpVersion(HttpVersion.V_1_1).setString_body("\u4f20\u4f60\u5988\u5462\uff1f").putHeaderContentType(ContentType.TEXT_PLAIN).setAssemble(true);
    private HttpVersion httpVersion;
    private String statue_code;
    private final DataMap header = new DataMap();
    private final ConcurrentDataSet<Cookie> cookie = new ConcurrentDataSet();
    private String string_body;
    private File file_body;
    private ByteBuffer compress_body;
    private boolean assemble = false;
    private boolean compress = false;

    public File gainFileBody() {
        return this.file_body;
    }

    boolean isAssemble() {
        return this.assemble;
    }

    Response setAssemble(boolean assemble) {
        this.assemble = assemble;
        return this;
    }

    public void setFile_body(File file_body) {
        this.file_body = file_body;
    }

    public Response putHeader(String key, String value) {
        this.header.put(key, (Object)value);
        return this;
    }

    public Response putHeaderToken(String value) {
        this.header.put("Token", (Object)value);
        return this;
    }

    public Response putHeaderServer() {
        this.header.put("Server", (Object)"QyHttpServer2.3");
        return this;
    }

    public Response putHeaderContentType(ContentType value) {
        this.header.put("Content-Type", (Object)value.toString());
        return this;
    }

    public ContentType gainHeaderContentType() {
        return ContentType.parse(this.header.getString("Content-Type"));
    }

    public Response putHeaderContentLength(long value) {
        this.header.put("Content-Length", (Object)String.valueOf(value));
        return this;
    }

    public String gainHeaderContentLength() {
        return this.header.getString("Content-Length");
    }

    public Response putHeaderAcceptRanges() {
        this.header.put("Accept-Ranges", (Object)"bytes");
        return this;
    }

    public Response putHeaderContentRanges() {
        this.header.put("Content-Ranges", (Object)"bytes=0-1");
        return this;
    }

    public Response putHeaderCROS() {
        this.header.put("Access-Control-Allow-Origin", (Object)"*");
        return this;
    }

    public String getHeaderCROS() {
        return this.header.getString("Access-Control-Allow-Origin");
    }

    public Response putHeaderRedirect(String url) {
        this.header.put("Location", (Object)url);
        return this;
    }

    public String getHeaderRedirect() {
        return this.header.getString("Location");
    }

    public void putHeaderCompress() {
        this.compress = true;
        this.header.put("Content-Encoding", (Object)"gzip");
    }

    public boolean isCompress() {
        return this.compress;
    }

    public Response putHeaderDate(ZonedDateTime ldt) {
        String s = LocalDateTimeUtil.HTTP_FORMATTER.format(ldt);
        this.header.put("Date", (Object)LocalDateTimeUtil.formatHttpTime((String)s));
        return this;
    }

    public Response setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public Response setStatue_code(String statue_code) {
        this.statue_code = statue_code;
        return this;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public String getStatue_code() {
        return this.statue_code;
    }

    public DataMap getHeader() {
        return this.header;
    }

    String getStrBody() {
        return this.string_body;
    }

    public Response setString_body(String string_body) {
        this.string_body = string_body;
        return this;
    }

    void setCompress_body(ByteBuffer compress_body) {
        this.compress_body = compress_body;
    }

    ByteBuffer gainBodyBytes() throws FileNotFoundException {
        if (this.compress) {
            return this.compress_body;
        }
        byte[] bytes = this.string_body == null ? ArrayUtil.EMPTY_BYTE_ARRAY : this.string_body.getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    File getFile_body() {
        return this.file_body;
    }

    public void addCookie(Cookie c) {
        this.cookie.add((Object)c);
    }

    public String toString() {
        this.putHeaderServer();
        StringBuilder sb = new StringBuilder();
        sb.append(this.httpVersion.getV()).append(" ").append(this.statue_code).append("\r\n");
        if (StringUtils.isBlank((CharSequence)this.gainHeaderContentLength())) {
            if (StringUtils.isNotBlank((CharSequence)this.string_body)) {
                this.putHeaderContentLength(this.string_body.getBytes(StandardCharsets.UTF_8).length);
            } else if (this.file_body != null) {
                this.putHeaderContentLength(this.file_body.length());
            }
        }
        this.header.forEach((k, v) -> sb.append((String)k).append(":").append(" ").append(v).append("\r\n"));
        this.cookie.forEach(e -> sb.append(e.toSetString()));
        sb.append("\r\n");
        return sb.toString();
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }
}

