/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.graphics.image;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import top.zenyoung.graphics.util.FileTypeUtils;
import top.zenyoung.graphics.util.ImageUtils;

public class BackgroundRemoval {
    public static String[] IMAGES_TYPE = new String[]{"jpg", "png"};

    public static boolean backgroundRemoval(@Nonnull String inputPath, @Nonnull String outputPath, int tolerance) throws IOException {
        return BackgroundRemoval.backgroundRemoval(new File(inputPath), new File(outputPath), tolerance);
    }

    public static boolean backgroundRemoval(@Nonnull File input, @Nonnull File output, int tolerance) throws IOException {
        return BackgroundRemoval.backgroundRemoval(input, output, null, tolerance);
    }

    public static boolean backgroundRemoval(@Nonnull File input, @Nonnull File output, @Nullable Color override, int tolerance) throws IOException {
        if (BackgroundRemoval.fileTypeValidation(input, IMAGES_TYPE)) {
            return false;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(input);
            return ImageIO.write((RenderedImage)BackgroundRemoval.backgroundRemoval(bufferedImage, override, tolerance), "png", output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BufferedImage backgroundRemoval(@Nonnull BufferedImage bufferedImage, @Nullable Color override, int tolerance) {
        tolerance = Math.min(255, Math.max(tolerance, 0));
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        Object[] removeRgb = BackgroundRemoval.getRemoveRgb(bufferedImage);
        String mainColor = BackgroundRemoval.getMainColor(bufferedImage);
        int alpha = 0;
        for (int y = image.getMinY(); y < image.getHeight(); ++y) {
            for (int x = image.getMinX(); x < image.getWidth(); ++x) {
                boolean isTrue;
                int rgb = image.getRGB(x, y);
                String hex = ImageUtils.toHex((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                boolean bl = isTrue = Lists.newArrayList((Object[])removeRgb).contains(hex) || BackgroundRemoval.areColorsWithinTolerance(BackgroundRemoval.hexToRgb(mainColor), new Color(Integer.parseInt(hex.substring(1), 16)), tolerance);
                if (isTrue) {
                    rgb = override == null ? alpha + 1 << 24 | rgb & 0xFFFFFF : override.getRGB();
                }
                image.setRGB(x, y, rgb);
            }
        }
        graphics.drawImage(image, 0, 0, imageIcon.getImageObserver());
        return image;
    }

    public static BufferedImage backgroundRemoval(@Nonnull ByteArrayOutputStream outputStream, @Nullable Color override, int tolerance) {
        try {
            return BackgroundRemoval.backgroundRemoval(ImageIO.read(new ByteArrayInputStream(outputStream.toByteArray())), override, tolerance);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] getRemoveRgb(@Nonnull BufferedImage image) {
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int leftUpPixel = image.getRGB(1, 1);
        String leftUp = ImageUtils.toHex((leftUpPixel & 0xFF0000) >> 16, (leftUpPixel & 0xFF00) >> 8, leftUpPixel & 0xFF);
        int upMiddlePixel = image.getRGB(width / 2, 1);
        String upMiddle = ImageUtils.toHex((upMiddlePixel & 0xFF0000) >> 16, (upMiddlePixel & 0xFF00) >> 8, upMiddlePixel & 0xFF);
        int rightUpPixel = image.getRGB(width, 1);
        String rightUp = ImageUtils.toHex((rightUpPixel & 0xFF0000) >> 16, (rightUpPixel & 0xFF00) >> 8, rightUpPixel & 0xFF);
        int rightMiddlePixel = image.getRGB(width, height / 2);
        String rightMiddle = ImageUtils.toHex((rightMiddlePixel & 0xFF0000) >> 16, (rightMiddlePixel & 0xFF00) >> 8, rightMiddlePixel & 0xFF);
        int lowerRightPixel = image.getRGB(width, height);
        String lowerRight = ImageUtils.toHex((lowerRightPixel & 0xFF0000) >> 16, (lowerRightPixel & 0xFF00) >> 8, lowerRightPixel & 0xFF);
        int lowerMiddlePixel = image.getRGB(width / 2, height);
        String lowerMiddle = ImageUtils.toHex((lowerMiddlePixel & 0xFF0000) >> 16, (lowerMiddlePixel & 0xFF00) >> 8, lowerMiddlePixel & 0xFF);
        int leftLowerPixel = image.getRGB(1, height);
        String leftLower = ImageUtils.toHex((leftLowerPixel & 0xFF0000) >> 16, (leftLowerPixel & 0xFF00) >> 8, leftLowerPixel & 0xFF);
        int leftMiddlePixel = image.getRGB(1, height / 2);
        String leftMiddle = ImageUtils.toHex((leftMiddlePixel & 0xFF0000) >> 16, (leftMiddlePixel & 0xFF00) >> 8, leftMiddlePixel & 0xFF);
        return new String[]{leftUp, upMiddle, rightUp, rightMiddle, lowerRight, lowerMiddle, leftLower, leftMiddle};
    }

    public static Color hexToRgb(@Nonnull String hex) {
        return new Color(Integer.parseInt(hex.substring(1), 16));
    }

    public static boolean areColorsWithinTolerance(@Nonnull Color color1, @Nonnull Color color2, int tolerance) {
        return BackgroundRemoval.areColorsWithinTolerance(color1, color2, new Color(tolerance, tolerance, tolerance));
    }

    public static boolean areColorsWithinTolerance(@Nonnull Color color1, @Nonnull Color color2, @Nonnull Color tolerance) {
        return color1.getRed() - color2.getRed() < tolerance.getRed() && color1.getRed() - color2.getRed() > -tolerance.getRed() && color1.getBlue() - color2.getBlue() < tolerance.getBlue() && color1.getBlue() - color2.getBlue() > -tolerance.getBlue() && color1.getGreen() - color2.getGreen() < tolerance.getGreen() && color1.getGreen() - color2.getGreen() > -tolerance.getGreen();
    }

    public static String getMainColor(@Nonnull String input) {
        return BackgroundRemoval.getMainColor(new File(input));
    }

    public static String getMainColor(@Nonnull File input) {
        try {
            return BackgroundRemoval.getMainColor(ImageIO.read(input));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getMainColor(@Nonnull BufferedImage bufferedImage) {
        int rgbLength;
        LinkedList list = Lists.newLinkedList();
        for (int y = bufferedImage.getMinY(); y < bufferedImage.getHeight(); ++y) {
            for (int x = bufferedImage.getMinX(); x < bufferedImage.getWidth(); ++x) {
                int pixel = bufferedImage.getRGB(x, y);
                list.add(((pixel & 0xFF0000) >> 16) + "-" + ((pixel & 0xFF00) >> 8) + "-" + (pixel & 0xFF));
            }
        }
        HashMap map = Maps.newHashMap();
        for (String string : list) {
            Integer integer = (Integer)map.get(string);
            if (integer == null) {
                integer = 1;
            } else {
                Integer n = integer;
                Integer n2 = integer = Integer.valueOf(integer + 1);
            }
            map.put(string, integer);
        }
        String max = "";
        long num = 0L;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Integer temp = (Integer)entry.getValue();
            if (!Strings.isNullOrEmpty((String)max) && (long)temp.intValue() <= num) continue;
            max = key;
            num = temp.intValue();
        }
        String[] strings = max.split("-");
        if (strings.length == (rgbLength = 3)) {
            return ImageUtils.toHex(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
        }
        return "";
    }

    private static boolean fileTypeValidation(@Nonnull File input, @Nonnull String[] imagesType) throws IOException {
        List imgTypes;
        if (!input.exists()) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u6587\u4ef6\u4e3a\u7a7a");
        }
        String type = FileTypeUtils.getType(input);
        if (!Strings.isNullOrEmpty((String)type) && !(imgTypes = Stream.of(imagesType).filter(val -> !Strings.isNullOrEmpty((String)val)).map(String::toUpperCase).collect(Collectors.toList())).contains(type)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u7c7b\u578b" + type + "\u4e0d\u652f\u6301");
        }
        return false;
    }
}

