/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.graphics.image;

import com.google.common.base.Strings;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.FilenameUtils;
import top.zenyoung.graphics.util.FontUtils;
import top.zenyoung.graphics.util.GraphicsUtils;
import top.zenyoung.graphics.util.ImageUtils;

public class LocalImage
implements Serializable {
    private final BufferedImage srcImage;
    private Image targetImage;
    private String targetImageType;
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;

    public static LocalImage from(@Nonnull Path imagePath) throws IOException {
        return LocalImage.from(imagePath.toFile());
    }

    public static LocalImage from(@Nonnull File imageFile) throws IOException {
        return new LocalImage(ImageUtils.read(imageFile));
    }

    public static LocalImage from(@Nonnull InputStream in) throws IOException {
        return new LocalImage(ImageUtils.read(in));
    }

    public static LocalImage from(@Nonnull ImageInputStream imageStream) throws IOException {
        return new LocalImage(ImageUtils.read(imageStream));
    }

    public static LocalImage from(@Nonnull URL imageUrl) throws IOException {
        return new LocalImage(ImageUtils.read(imageUrl));
    }

    public static LocalImage from(@Nonnull Image image) {
        return new LocalImage(ImageUtils.toBufferedImage(image));
    }

    public LocalImage(@Nonnull BufferedImage srcImage) {
        this(srcImage, null);
    }

    public LocalImage(@Nonnull BufferedImage srcImage, @Nullable String targetImageType) {
        this.srcImage = srcImage;
        if (Strings.isNullOrEmpty((String)targetImageType)) {
            targetImageType = srcImage.getType() == 2 || srcImage.getType() == 3 || srcImage.getType() == 6 || srcImage.getType() == 7 ? "png" : "jpg";
        }
        this.targetImageType = targetImageType;
    }

    public LocalImage setTargetImageType(@Nonnull String imgType) {
        this.targetImageType = imgType;
        return this;
    }

    public LocalImage setPositionBaseCentre(boolean positionBaseCentre) {
        this.positionBaseCentre = positionBaseCentre;
        return this;
    }

    public LocalImage setQuality(double quality) {
        return this.setQuality((float)quality);
    }

    public LocalImage setQuality(float quality) {
        this.quality = quality > 0.0f && quality < 1.0f ? quality : 1.0f;
        return this;
    }

    public LocalImage scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        Image srcImg = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            double scaleDouble = Double.parseDouble(((Object)Float.valueOf(scale)).toString());
            this.targetImage = ImageUtils.transform(AffineTransform.getScaleInstance(scaleDouble, scaleDouble), ImageUtils.toBufferedImage(srcImg, this.targetImageType));
        } else {
            int width = ImageUtils.multi(srcImg.getWidth(null), Float.valueOf(scale)).intValue();
            int height = ImageUtils.multi(srcImg.getHeight(null), Float.valueOf(scale)).intValue();
            this.scale(width, height);
        }
        return this;
    }

    public LocalImage scale(int width, int height) {
        return this.scale(width, height, 4);
    }

    public LocalImage scale(int width, int height, int scaleType) {
        Image srcImg = this.getValidSrcImg();
        int srcHeight = srcImg.getHeight(null);
        int srcWidth = srcImg.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImg;
            return this;
        }
        if ("png".equals(this.targetImageType)) {
            double sx = (double)width / (double)srcWidth;
            double sy = (double)height / (double)srcHeight;
            this.targetImage = ImageUtils.transform(AffineTransform.getScaleInstance(sx, sy), ImageUtils.toBufferedImage(srcImg, this.targetImageType));
        } else {
            this.targetImage = srcImg.getScaledInstance(width, height, scaleType);
        }
        return this;
    }

    public LocalImage scale(int width, int height, @Nullable Color fixedColor) {
        Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = (double)height / (double)srcHeight;
        double widthRatio = (double)width / (double)srcWidth;
        if (Double.doubleToLongBits(heightRatio) == Double.doubleToLongBits(widthRatio)) {
            this.scale(width, height);
        } else if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        srcImage = this.getValidSrcImg();
        srcHeight = srcImage.getHeight(null);
        srcWidth = srcImage.getWidth(null);
        BufferedImage image = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D g = image.createGraphics();
        if (null != fixedColor) {
            g.setBackground(fixedColor);
            g.clearRect(0, 0, width, height);
        }
        g.drawImage(srcImage, (width - srcWidth) / 2, (height - srcHeight) / 2, srcWidth, srcHeight, fixedColor, null);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public LocalImage cut(@Nonnull Rectangle rectangle) {
        Image srcImage = this.getValidSrcImg();
        this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.targetImage = ImageUtils.filter(cropFilter, srcImage);
        return this;
    }

    public LocalImage cut(int x, int y) {
        return this.cut(x, y, -1);
    }

    public LocalImage cut(int x, int y, int radius) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        int diameter = radius > 0 ? radius * 2 : Math.min(width, height);
        BufferedImage targetImage = new BufferedImage(diameter, diameter, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setClip(new Ellipse2D.Double(0.0, 0.0, diameter, diameter));
        if (this.positionBaseCentre) {
            x = x - width / 2 + diameter / 2;
            y = y - height / 2 + diameter / 2;
        }
        g.drawImage(srcImage, x, y, null);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public LocalImage round(double arc) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        arc = ImageUtils.multi(arc, Math.min(width, height)).doubleValue();
        BufferedImage targetImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = targetImage.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(srcImage, 0, 0, null);
        g2.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public LocalImage gray() {
        this.targetImage = ImageUtils.colorConvert(ColorSpace.getInstance(1003), this.getValidSrcBufferedImg());
        return this;
    }

    public LocalImage binary() {
        this.targetImage = ImageUtils.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    public LocalImage pressText(@Nonnull String pressText, @Nonnull Color color, @Nullable Font font, int x, int y, float alpha) {
        return this.pressText(pressText, color, font, new Point(x, y), alpha);
    }

    public LocalImage pressText(@Nonnull String pressText, @Nonnull Color color, @Nullable Font font, @Nonnull Point point, float alpha) {
        BufferedImage targetImage = ImageUtils.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        if (Objects.isNull(font)) {
            font = FontUtils.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        Graphics2D g = targetImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        if (this.positionBaseCentre) {
            GraphicsUtils.drawString((Graphics)g, pressText, font, color, new Rectangle(point.x, point.y, targetImage.getWidth(), targetImage.getHeight()));
        } else {
            GraphicsUtils.drawString((Graphics)g, pressText, font, color, point);
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public static int getCenterY(@Nonnull Graphics g, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static Graphics drawString(@Nonnull Graphics g, @Nonnull String str, @Nonnull Font font, @Nullable Color color, int width, int height) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        int midY = LocalImage.getCenterY(g, height);
        if (null != color) {
            g.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                g.setColor(ImageUtils.randomColor());
            }
            g.drawString(String.valueOf(str.charAt(i)), i * charWidth, midY);
        }
        return g;
    }

    public static Dimension getDimension(@Nonnull FontMetrics metrics, @Nonnull String str) {
        int width = metrics.stringWidth(str);
        int height = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        return new Dimension(width, height);
    }

    public LocalImage pressTextFull(@Nonnull String pressText, @Nonnull Color color, @Nullable Font font, int lineHeight, int degree, float alpha) {
        Dimension dimension;
        BufferedImage targetImage = ImageUtils.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        if (Objects.isNull(font)) {
            font = FontUtils.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        int targetHeight = targetImage.getHeight();
        int targetWidth = targetImage.getWidth();
        Graphics2D g = targetImage.createGraphics();
        g.setColor(color);
        g.rotate(Math.toRadians(degree), targetWidth >> 1, targetHeight >> 1);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        try {
            dimension = LocalImage.getDimension(g.getFontMetrics(font), pressText);
        }
        catch (Exception e) {
            dimension = new Dimension(targetWidth / 3, targetHeight / 3);
        }
        int intervalHeight = dimension.height * lineHeight;
        int y = -targetHeight >> 1;
        while ((double)y < (double)targetHeight * 1.5) {
            int x = -targetWidth >> 1;
            while ((double)x < (double)targetWidth * 1.5) {
                GraphicsUtils.drawString((Graphics)g, pressText, font, color, new Point(x, y));
                x += dimension.width;
            }
            y += intervalHeight;
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public LocalImage pressImage(@Nonnull Image pressImg, int x, int y, float alpha) {
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        return this.pressImage(pressImg, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public LocalImage pressImage(@Nonnull Image pressImg, @Nonnull Rectangle rectangle, float alpha) {
        Image targetImg = this.getValidSrcImg();
        this.targetImage = this.draw(ImageUtils.toBufferedImage(targetImg, this.targetImageType), pressImg, rectangle, alpha);
        return this;
    }

    public LocalImage rotate(int degree) {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = LocalImage.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.translate((double)(rectangle.width - width) / 2.0, (double)(rectangle.height - height) / 2.0);
        graphics2d.rotate(Math.toRadians(degree), (double)width / 2.0, (double)height / 2.0);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public LocalImage flip() {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public LocalImage stroke(@Nullable Color color, float width) {
        return this.stroke(color, new BasicStroke(width));
    }

    public LocalImage stroke(@Nullable Color color, @Nullable Stroke stroke) {
        BufferedImage image = ImageUtils.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Graphics2D g = image.createGraphics();
        g.setColor(Objects.isNull(color) ? Color.BLACK : color);
        if (Objects.nonNull(stroke)) {
            g.setStroke(stroke);
        }
        g.drawRect(0, 0, width - 1, height - 1);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public Image getImg() {
        return this.getValidSrcImg();
    }

    public boolean write(@Nonnull OutputStream out) throws IOException {
        return this.write(ImageUtils.getImageOutputStream(out));
    }

    public boolean write(@Nonnull ImageOutputStream targetImageStream) throws IOException {
        Image targetImage;
        if (Strings.isNullOrEmpty((String)this.targetImageType)) {
            throw new IllegalArgumentException("Target image type is blank !");
        }
        Image image = targetImage = null == this.targetImage ? this.srcImage : this.targetImage;
        if (Objects.isNull(targetImage)) {
            throw new IllegalArgumentException("Target image is null");
        }
        return ImageUtils.write(targetImage, this.targetImageType, targetImageStream, this.quality);
    }

    public boolean write(@Nonnull File targetFile) throws IOException {
        String formatName = FilenameUtils.getExtension((String)targetFile.getName());
        if (!Strings.isNullOrEmpty((String)formatName)) {
            this.targetImageType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        try (ImageOutputStream out = ImageUtils.getImageOutputStream(targetFile);){
            boolean bl = this.write(out);
            return bl;
        }
    }

    private BufferedImage draw(@Nonnull BufferedImage backgroundImg, @Nonnull Image img, @Nonnull Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        LocalImage.setAlpha(g, alpha);
        this.fixRectangle(rectangle, backgroundImg.getWidth(), backgroundImg.getHeight());
        GraphicsUtils.drawImg((Graphics)g, img, rectangle);
        g.dispose();
        return backgroundImg;
    }

    private static void setAlpha(@Nonnull Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(10, alpha));
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return Objects.isNull(this.targetImage) ? this.srcImage : this.targetImage;
    }

    private BufferedImage getValidSrcBufferedImg() {
        return ImageUtils.toBufferedImage(this.getValidSrcImg(), this.targetImageType);
    }

    private void fixRectangle(@Nonnull Rectangle rectangle, int baseWidth, int baseHeight) {
        if (this.positionBaseCentre) {
            Point pointBaseCentre = ImageUtils.getPointBaseCentre(rectangle, baseWidth, baseHeight);
            rectangle.setLocation(pointBaseCentre.x, pointBaseCentre.y);
        }
    }

    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        if (degree < 0) {
            degree += 360;
        }
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        double r = Math.sqrt(height * height + width * width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angel_dalta_width = Math.atan((double)height / (double)width);
        double angel_dalta_height = Math.atan((double)width / (double)height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = width + len_dalta_width * 2;
        int des_height = height + len_dalta_height * 2;
        return new Rectangle(des_width, des_height);
    }
}

