/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.graphics.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;

public class FileTypeUtils {
    private static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>(50){
        {
            this.put("ffd8ff", "jpg");
            this.put("89504e47", "png");
            this.put("4749463837", "gif");
            this.put("4749463839", "gif");
            this.put("49492a00227105008037", "tif");
            this.put("424d228c010000000000", "bmp");
            this.put("424d8240090000000000", "bmp");
            this.put("424d8e1b030000000000", "bmp");
            this.put("41433130313500000000", "dwg");
            this.put("7b5c727466315c616e73", "rtf");
            this.put("38425053000100000000", "psd");
            this.put("46726f6d3a203d3f6762", "eml");
            this.put("5374616E64617264204A", "mdb");
            this.put("252150532D41646F6265", "ps");
            this.put("255044462d312e", "pdf");
            this.put("2e524d46000000120001", "rmvb");
            this.put("464c5601050000000900", "flv");
            this.put("0000001C66747970", "mp4");
            this.put("00000020667479706", "mp4");
            this.put("00000018667479706D70", "mp4");
            this.put("49443303000000002176", "mp3");
            this.put("000001ba210001000180", "mpg");
            this.put("3026b2758e66cf11a6d9", "wmv");
            this.put("52494646e27807005741", "wav");
            this.put("52494646d07d60074156", "avi");
            this.put("4d546864000000060001", "mid");
            this.put("526172211a0700cf9073", "rar");
            this.put("235468697320636f6e66", "ini");
            this.put("504B03040a0000000000", "jar");
            this.put("504B0304140008000800", "jar");
            this.put("d0cf11e0a1b11ae10", "xls");
            this.put("504B0304", "zip");
            this.put("4d5a9000030000000400", "exe");
            this.put("3c25402070616765206c", "jsp");
            this.put("4d616e69666573742d56", "mf");
            this.put("7061636b616765207765", "java");
            this.put("406563686f206f66660d", "bat");
            this.put("1f8b0800000000000000", "gz");
            this.put("cafebabe0000002e0041", "class");
            this.put("49545346030000006000", "chm");
            this.put("04000000010000001300", "mxp");
            this.put("6431303a637265617465", "torrent");
            this.put("6D6F6F76", "mov");
            this.put("FF575043", "wpd");
            this.put("CFAD12FEC5FD746F", "dbx");
            this.put("2142444E", "pst");
            this.put("AC9EBD8F", "qdf");
            this.put("E3828596", "pwl");
            this.put("2E7261FD", "ram");
        }
    };

    public static String getType(@Nonnull String fileStreamHexHead) {
        for (Map.Entry<String, String> fileTypeEntry : FILE_TYPE_MAP.entrySet()) {
            if (!fileStreamHexHead.equalsIgnoreCase(fileTypeEntry.getKey())) continue;
            return fileTypeEntry.getValue();
        }
        return null;
    }

    public static String getType(@Nonnull InputStream in) throws IOException {
        byte[] buf;
        int len = 28;
        if (in.available() > 28 && in.read(buf = new byte[28], 0, 28) >= 28) {
            return FileTypeUtils.getType(Hex.encodeHexString((byte[])buf));
        }
        return null;
    }

    public static String getType(@Nonnull InputStream in, @Nonnull String filename) throws IOException {
        String extName = FilenameUtils.getExtension((String)filename);
        String typeName = FileTypeUtils.getType(in);
        if (null == typeName) {
            typeName = extName;
        } else if ("xls".equals(typeName)) {
            if ("doc".equalsIgnoreCase(extName)) {
                typeName = "doc";
            } else if ("msi".equalsIgnoreCase(extName)) {
                typeName = "msi";
            }
        } else if ("zip".equals(typeName)) {
            if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("jar".equalsIgnoreCase(extName)) {
                typeName = "jar";
            } else if ("war".equalsIgnoreCase(extName)) {
                typeName = "war";
            } else if ("ofd".equalsIgnoreCase(extName)) {
                typeName = "ofd";
            }
        } else if ("jar".equals(typeName)) {
            if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            }
        }
        return typeName;
    }

    public static String getType(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = FileTypeUtils.getType(in, file.getName());
            return string;
        }
    }
}

