/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.graphics.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class FontUtils {
    public static Font createFont() {
        return new Font(null);
    }

    public static Font createSansSerifFont(int size) {
        return FontUtils.createFont("SansSerif", size);
    }

    public static Font createFont(@Nonnull String name, int size) {
        return new Font(name, 0, size);
    }

    public static Font createFont(@Nonnull File fontFile) throws IOException {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static Font createFont(@Nonnull InputStream fontStream) throws IOException {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static Dimension getDimension(@Nonnull FontMetrics metrics, @Nonnull String str) {
        int width = metrics.stringWidth(str);
        int height = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        return new Dimension(width, height);
    }
}

