/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.graphics.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import top.zenyoung.graphics.util.FontUtils;
import top.zenyoung.graphics.util.ImageUtils;

public class GraphicsUtils {
    public static Graphics2D createGraphics(@Nonnull BufferedImage image, @Nullable Color color) {
        Graphics2D g = image.createGraphics();
        if (null != color) {
            g.setColor(color);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g;
    }

    public static int getCenterY(@Nonnull Graphics g, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static Graphics drawStringColourful(@Nonnull Graphics g, @Nonnull String text, @Nonnull Font font, int width, int height) {
        return GraphicsUtils.drawString(g, text, font, null, width, height);
    }

    public static Graphics drawString(@Nonnull Graphics g, @Nonnull String text, @Nonnull Font font, @Nullable Color color, int width, int height) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        int midY = GraphicsUtils.getCenterY(g, height);
        if (null != color) {
            g.setColor(color);
        }
        int len = text.length();
        int charWidth = width / len;
        for (int i = 0; i < len; ++i) {
            if (null == color) {
                g.setColor(ImageUtils.randomColor());
            }
            g.drawString(String.valueOf(text.charAt(i)), i * charWidth, midY);
        }
        return g;
    }

    public static Graphics drawString(@Nonnull Graphics g, @Nonnull String str, @Nonnull Font font, @Nonnull Color color, @Nonnull Rectangle rectangle) {
        Dimension dimension;
        int backgroundWidth = rectangle.width;
        int backgroundHeight = rectangle.height;
        try {
            dimension = FontUtils.getDimension(g.getFontMetrics(font), str);
        }
        catch (Exception e) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImageUtils.getPointBaseCentre(rectangle, backgroundWidth, backgroundHeight);
        return GraphicsUtils.drawString(g, str, font, color, point);
    }

    public static Graphics drawString(@Nonnull Graphics g, @Nonnull String str, @Nonnull Font font, @Nullable Color color, @Nonnull Point point) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        g.setColor(Objects.isNull(color) ? Color.BLACK : color);
        g.drawString(str, point.x, point.y);
        return g;
    }

    public static Graphics drawImg(@Nonnull Graphics g, @Nonnull Image img, @Nonnull Point point) {
        return GraphicsUtils.drawImg(g, img, new Rectangle(point.x, point.y, img.getWidth(null), img.getHeight(null)));
    }

    public static Graphics drawImg(@Nonnull Graphics g, @Nonnull Image img, @Nonnull Rectangle rectangle) {
        g.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        return g;
    }

    public static Graphics2D setAlpha(@Nonnull Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        return g;
    }
}

