/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.graphics.util;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import top.zenyoung.graphics.image.BackgroundRemoval;
import top.zenyoung.graphics.image.LocalImage;
import top.zenyoung.graphics.util.FontUtils;
import top.zenyoung.graphics.util.GraphicsUtils;

public class ImageUtils {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";
    private static final int RGB_COLOR_BOUND = 256;

    public static void scale(@Nonnull File srcImageFile, @Nonnull File destImageFile, float scale) throws IOException {
        ImageUtils.scale((Image)ImageUtils.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream, float scale) throws IOException {
        ImageUtils.scale((Image)ImageUtils.read(srcStream), destStream, scale);
    }

    public static void scale(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream, float scale) throws IOException {
        ImageUtils.scale((Image)ImageUtils.read(srcStream), destStream, scale);
    }

    public static void scale(@Nonnull Image srcImg, @Nonnull File destFile, float scale) throws IOException {
        String extName = FilenameUtils.getExtension((String)destFile.getName());
        LocalImage.from(srcImg).setTargetImageType(extName).scale(scale).write(destFile);
    }

    public static BigDecimal multi(Number ... values) {
        int totals = values.length;
        if (totals <= 0) {
            return BigDecimal.ZERO;
        }
        Number val = values[0];
        BigDecimal result = new BigDecimal(val.toString());
        boolean startIdx = true;
        if (totals > 1) {
            for (int i = 1; i < totals; ++i) {
                val = values[i];
                result = result.multiply(new BigDecimal(val.toString()));
            }
        }
        return result;
    }

    public static void scale(@Nonnull Image srcImg, @Nonnull OutputStream out, float scale) throws IOException {
        ImageUtils.scale(srcImg, ImageUtils.getImageOutputStream(out), scale);
    }

    public static void scale(@Nonnull Image srcImg, @Nonnull ImageOutputStream destImageStream, float scale) throws IOException {
        ImageUtils.writeJpg(ImageUtils.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(@Nonnull Image srcImg, float scale) {
        return LocalImage.from(srcImg).scale(scale).getImg();
    }

    public static Image scale(@Nonnull Image srcImg, int width, int height) {
        return LocalImage.from(srcImg).scale(width, height).getImg();
    }

    public static void scale(@Nonnull File srcImageFile, @Nonnull File destImageFile, int width, int height, @Nullable Color fixedColor) throws IOException {
        String extName = FilenameUtils.getExtension((String)destImageFile.getName());
        LocalImage.from(srcImageFile).setTargetImageType(extName).scale(width, height, fixedColor).write(destImageFile);
    }

    public static void scale(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream, int width, int height, @Nullable Color fixedColor) throws IOException {
        ImageUtils.scale(ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream, int width, int height, @Nullable Color fixedColor) throws IOException {
        ImageUtils.scale(ImageUtils.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(@Nonnull Image srcImage, @Nonnull ImageOutputStream destImageStream, int width, int height, @Nullable Color fixedColor) throws IOException {
        ImageUtils.writeJpg(ImageUtils.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(@Nonnull Image srcImage, int width, int height, @Nullable Color fixedColor) {
        return LocalImage.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(@Nonnull File srcImgFile, @Nonnull File destImgFile, @Nonnull Rectangle rectangle) throws IOException {
        ImageUtils.cut((Image)ImageUtils.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream, @Nonnull Rectangle rectangle) throws IOException {
        ImageUtils.cut((Image)ImageUtils.read(srcStream), destStream, rectangle);
    }

    public static void cut(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream, @Nonnull Rectangle rectangle) throws IOException {
        ImageUtils.cut((Image)ImageUtils.read(srcStream), destStream, rectangle);
    }

    public static void cut(@Nonnull Image srcImage, @Nonnull File destFile, @Nonnull Rectangle rectangle) throws IOException {
        ImageUtils.write(ImageUtils.cut(srcImage, rectangle), destFile);
    }

    public static void cut(@Nonnull Image srcImage, @Nonnull OutputStream out, @Nonnull Rectangle rectangle) throws IOException {
        ImageUtils.cut(srcImage, ImageUtils.getImageOutputStream(out), rectangle);
    }

    public static void cut(@Nonnull Image srcImage, @Nonnull ImageOutputStream destImageStream, @Nonnull Rectangle rectangle) throws IOException {
        ImageUtils.writeJpg(ImageUtils.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(@Nonnull Image srcImage, @Nonnull Rectangle rectangle) {
        return LocalImage.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(@Nonnull Image srcImage, int x, int y) {
        return ImageUtils.cut(srcImage, x, y, -1);
    }

    public static Image cut(@Nonnull Image srcImage, int x, int y, int radius) {
        return LocalImage.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(@Nonnull File srcImageFile, @Nonnull File descDir, int destWidth, int destHeight) throws IOException {
        ImageUtils.slice(ImageUtils.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(@Nonnull Image srcImage, @Nonnull File descDir, int destWidth, int destHeight) throws IOException {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < destWidth) {
            destWidth = srcWidth;
        }
        if (srcHeight < destHeight) {
            destHeight = srcHeight;
        }
        int cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor((double)srcWidth / (double)destWidth) + 1;
        int rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor((double)srcHeight / (double)destHeight) + 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImageUtils.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImageUtils.write(tag, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
            }
        }
    }

    public static void sliceByRowsAndCols(@Nonnull File srcImageFile, @Nonnull File destDir, int rows, int cols) throws IOException {
        ImageUtils.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, rows, cols);
    }

    public static void sliceByRowsAndCols(@Nonnull Image srcImage, @Nonnull File destDir, int rows, int cols) throws IOException {
        if (!destDir.exists()) {
            boolean bl = destDir.mkdirs();
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        if (rows <= 0 || rows > 20) {
            rows = 2;
        }
        if (cols <= 0 || cols > 20) {
            cols = 2;
        }
        BufferedImage bi = ImageUtils.toBufferedImage(srcImage);
        int srcWidth = bi.getWidth();
        int srcHeight = bi.getHeight();
        int destWidth = ImageUtils.partValue(srcWidth, cols);
        int destHeight = ImageUtils.partValue(srcHeight, rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImageUtils.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImageIO.write(ImageUtils.toRenderedImage(tag), IMAGE_TYPE_JPEG, new File(destDir, "_r" + i + "_c" + j + ".jpg"));
            }
        }
    }

    private static int partValue(int total, int partCount) {
        return ImageUtils.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static void convert(@Nonnull File srcImageFile, @Nonnull File destImageFile) throws IOException {
        String destExtName;
        if (srcImageFile == destImageFile) {
            throw new IllegalArgumentException("Src file is equals to dest file!");
        }
        String srcExtName = FilenameUtils.getExtension((String)srcImageFile.getName());
        if (srcExtName.equalsIgnoreCase(destExtName = FilenameUtils.getExtension((String)destImageFile.getName()))) {
            FileUtils.copyFile((File)srcImageFile, (File)destImageFile);
        }
        try (ImageOutputStream imageOutputStream = ImageUtils.getImageOutputStream(destImageFile);){
            ImageUtils.convert(ImageUtils.read(srcImageFile), destExtName, imageOutputStream, IMAGE_TYPE_PNG.equalsIgnoreCase(srcExtName));
        }
    }

    public static void convert(@Nonnull InputStream srcStream, @Nonnull String formatName, @Nonnull OutputStream destStream) throws IOException {
        ImageUtils.write((Image)ImageUtils.read(srcStream), formatName, ImageUtils.getImageOutputStream(destStream));
    }

    public static void convert(@Nonnull Image srcImage, @Nonnull String formatName, @Nonnull ImageOutputStream destImageStream, boolean isSrcPng) throws IOException {
        ImageIO.write((RenderedImage)(isSrcPng ? ImageUtils.copyImage(srcImage, 1) : ImageUtils.toBufferedImage(srcImage)), formatName, destImageStream);
    }

    public static void gray(@Nonnull File srcImageFile, @Nonnull File destImageFile) throws IOException {
        ImageUtils.gray((Image)ImageUtils.read(srcImageFile), destImageFile);
    }

    public static void gray(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream) throws IOException {
        ImageUtils.gray((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream));
    }

    public static void gray(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream) throws IOException {
        ImageUtils.gray((Image)ImageUtils.read(srcStream), destStream);
    }

    public static void gray(@Nonnull Image srcImage, @Nonnull File outFile) throws IOException {
        ImageUtils.write(ImageUtils.gray(srcImage), outFile);
    }

    public static void gray(@Nonnull Image srcImage, @Nonnull OutputStream out) throws IOException {
        ImageUtils.gray(srcImage, ImageUtils.getImageOutputStream(out));
    }

    public static void gray(@Nonnull Image srcImage, @Nonnull ImageOutputStream destImageStream) throws IOException {
        ImageUtils.writeJpg(ImageUtils.gray(srcImage), destImageStream);
    }

    public static Image gray(@Nonnull Image srcImage) {
        return LocalImage.from(srcImage).gray().getImg();
    }

    public static void binary(@Nonnull File srcImageFile, @Nonnull File destImageFile) throws IOException {
        ImageUtils.binary(ImageUtils.read(srcImageFile), destImageFile);
    }

    public static void binary(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream, @Nonnull String imageType) throws IOException {
        ImageUtils.binary((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), imageType);
    }

    public static void binary(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream, @Nonnull String imageType) throws IOException {
        ImageUtils.binary((Image)ImageUtils.read(srcStream), destStream, imageType);
    }

    public static void binary(@Nonnull Image srcImage, @Nonnull File outFile) throws IOException {
        ImageUtils.write(ImageUtils.binary(srcImage), outFile);
    }

    public static void binary(@Nonnull Image srcImage, @Nonnull OutputStream out, @Nonnull String imageType) throws IOException {
        ImageUtils.binary(srcImage, ImageUtils.getImageOutputStream(out), imageType);
    }

    public static void binary(@Nonnull Image srcImage, @Nonnull ImageOutputStream destImageStream, @Nonnull String imageType) throws IOException {
        ImageUtils.write(ImageUtils.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(@Nonnull Image srcImage) {
        return LocalImage.from(srcImage).binary().getImg();
    }

    public static void pressText(@Nonnull File imageFile, @Nonnull File destFile, @Nonnull String pressText, @Nullable Color color, @Nonnull Font font, int x, int y, float alpha) throws IOException {
        ImageUtils.pressText((Image)ImageUtils.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream, @Nonnull String pressText, @Nullable Color color, @Nullable Font font, int x, int y, float alpha) throws IOException {
        ImageUtils.pressText((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream, @Nonnull String pressText, @Nullable Color color, @Nullable Font font, int x, int y, float alpha) throws IOException {
        ImageUtils.pressText((Image)ImageUtils.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(@Nonnull Image srcImage, @Nonnull File destFile, @Nonnull String pressText, @Nullable Color color, @Nullable Font font, int x, int y, float alpha) throws IOException {
        ImageUtils.write(ImageUtils.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(@Nonnull Image srcImage, @Nonnull OutputStream to, @Nonnull String pressText, @Nullable Color color, @Nullable Font font, int x, int y, float alpha) throws IOException {
        ImageUtils.pressText(srcImage, ImageUtils.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(@Nonnull Image srcImage, @Nonnull ImageOutputStream destImageStream, @Nonnull String pressText, @Nonnull Color color, @Nullable Font font, int x, int y, float alpha) throws IOException {
        ImageUtils.writeJpg(ImageUtils.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(@Nonnull Image srcImage, @Nonnull String pressText, @Nonnull Color color, @Nullable Font font, int x, int y, float alpha) {
        return LocalImage.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(@Nonnull File srcImageFile, @Nonnull File destImageFile, @Nonnull Image pressImg, int x, int y, float alpha) throws IOException {
        ImageUtils.pressImage((Image)ImageUtils.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static void pressImage(@Nonnull InputStream srcStream, @Nonnull OutputStream destStream, @Nonnull Image pressImg, int x, int y, float alpha) throws IOException {
        ImageUtils.pressImage((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), pressImg, x, y, alpha);
    }

    public static void pressImage(@Nonnull ImageInputStream srcStream, @Nonnull ImageOutputStream destStream, @Nonnull Image pressImg, int x, int y, float alpha) throws IOException {
        ImageUtils.pressImage((Image)ImageUtils.read(srcStream), destStream, pressImg, x, y, alpha);
    }

    public static void pressImage(@Nonnull Image srcImage, @Nonnull File outFile, @Nonnull Image pressImg, int x, int y, float alpha) throws IOException {
        ImageUtils.write(ImageUtils.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(@Nonnull Image srcImage, @Nonnull OutputStream out, @Nonnull Image pressImg, int x, int y, float alpha) throws IOException {
        ImageUtils.pressImage(srcImage, ImageUtils.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(@Nonnull Image srcImage, @Nonnull ImageOutputStream destImageStream, @Nonnull Image pressImg, int x, int y, float alpha) throws IOException {
        ImageUtils.writeJpg(ImageUtils.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static Image pressImage(@Nonnull Image srcImage, @Nonnull Image pressImg, int x, int y, float alpha) {
        return LocalImage.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static Image pressImage(@Nonnull Image srcImage, @Nonnull Image pressImg, @Nonnull Rectangle rectangle, float alpha) {
        return LocalImage.from(srcImage).pressImage(pressImg, rectangle, alpha).getImg();
    }

    public static void rotate(@Nonnull File imageFile, int degree, @Nonnull File outFile) throws IOException {
        ImageUtils.rotate((Image)ImageUtils.read(imageFile), degree, outFile);
    }

    public static void rotate(@Nonnull Image image, int degree, @Nonnull File outFile) throws IOException {
        ImageUtils.write(ImageUtils.rotate(image, degree), outFile);
    }

    public static void rotate(@Nonnull Image image, int degree, @Nonnull OutputStream out) throws IOException {
        ImageUtils.writeJpg(ImageUtils.rotate(image, degree), ImageUtils.getImageOutputStream(out));
    }

    public static void rotate(@Nonnull Image image, int degree, @Nonnull ImageOutputStream out) throws IOException {
        ImageUtils.writeJpg(ImageUtils.rotate(image, degree), out);
    }

    public static Image rotate(@Nonnull Image image, int degree) {
        return LocalImage.from(image).rotate(degree).getImg();
    }

    public static void flip(@Nonnull File imageFile, @Nonnull File outFile) throws IOException {
        ImageUtils.flip((Image)ImageUtils.read(imageFile), outFile);
    }

    public static void flip(@Nonnull Image image, @Nonnull File outFile) throws IOException {
        ImageUtils.write(ImageUtils.flip(image), outFile);
    }

    public static void flip(@Nonnull Image image, @Nonnull OutputStream out) throws IOException {
        ImageUtils.flip(image, ImageUtils.getImageOutputStream(out));
    }

    public static void flip(@Nonnull Image image, @Nonnull ImageOutputStream out) throws IOException {
        ImageUtils.writeJpg(ImageUtils.flip(image), out);
    }

    public static Image flip(@Nonnull Image image) {
        return LocalImage.from(image).flip().getImg();
    }

    public static void compress(@Nonnull File imageFile, @Nonnull File outFile, float quality) throws IOException {
        LocalImage.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(@Nonnull Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImageUtils.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(@Nonnull Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImageUtils.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(@Nonnull Image image, @Nullable String imageType) {
        int type = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return ImageUtils.toBufferedImage(image, type);
    }

    public static BufferedImage toBufferedImage(@Nonnull Image image, int imageType) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImageUtils.copyImage(image, imageType);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImageUtils.copyImage(image, imageType);
        return bufferedImage;
    }

    public static BufferedImage copyImage(@Nonnull Image img, int imageType) {
        return ImageUtils.copyImage(img, imageType, null);
    }

    public static BufferedImage copyImage(@Nonnull Image source, int imageType, @Nullable Color backgroundColor) {
        Image img = new ImageIcon(source).getImage();
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = bimage.createGraphics();
        if (backgroundColor != null) {
            bGr.setColor(backgroundColor);
            bGr.fillRect(0, 0, bimage.getWidth(), bimage.getHeight());
        }
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) throws HeadlessException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage toImage(@Nonnull String base64) throws IOException {
        return ImageUtils.toImage(Base64.decodeBase64((String)base64));
    }

    public static BufferedImage toImage(@Nonnull byte[] imageBytes) throws IOException {
        return ImageUtils.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(@Nonnull Image image, @Nullable String imageType) throws IOException {
        return new ByteArrayInputStream(ImageUtils.toBytes(image, imageType));
    }

    public static String toBase64DataUri(@Nonnull Image image, @Nullable String imageType) throws IOException {
        return ImageUtils.getDataUri("image/" + imageType, null, "base64", ImageUtils.toBase64(image, imageType));
    }

    public static String getDataUri(@Nonnull String mimeType, @Nullable Charset charset, @Nullable String encoding, @Nonnull String data) {
        StringBuilder builder = new StringBuilder("data:");
        if (!Strings.isNullOrEmpty((String)mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (!Strings.isNullOrEmpty((String)encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }

    public static String toBase64(@Nonnull Image image, @Nullable String imageType) throws IOException {
        return Base64.encodeBase64String((byte[])ImageUtils.toBytes(image, imageType));
    }

    public static byte[] toBytes(@Nonnull Image image, @Nullable String imageType) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtils.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(@Nonnull String text, @Nonnull Font font, @Nullable Color backgroundColor, @Nullable Color fontColor, @Nonnull ImageOutputStream out) throws IOException {
        ImageUtils.writePng((Image)ImageUtils.createImage(text, font, backgroundColor, fontColor, 2), out);
    }

    public static BufferedImage createImage(@Nonnull String text, @Nonnull Font font, @Nullable Color backgroundColor, @Nullable Color fontColor, int imageType) {
        Rectangle2D r = ImageUtils.getRectangle(text, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(Objects.isNull(fontColor) ? Color.BLACK : fontColor);
        g.setFont(font);
        g.drawString(text, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(@Nonnull String text, @Nonnull Font font) {
        return font.getStringBounds(text, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(@Nonnull File fontFile) throws IOException {
        return FontUtils.createFont(fontFile);
    }

    public static Font createFont(@Nonnull InputStream fontStream) throws IOException {
        return FontUtils.createFont(fontStream);
    }

    public static Graphics2D createGraphics(@Nonnull BufferedImage image, @Nullable Color color) {
        return GraphicsUtils.createGraphics(image, color);
    }

    public static void writeJpg(@Nonnull Image image, @Nonnull ImageOutputStream destImageStream) throws IOException {
        ImageUtils.write(image, IMAGE_TYPE_JPG, destImageStream);
    }

    public static void writePng(@Nonnull Image image, @Nonnull ImageOutputStream destImageStream) throws IOException {
        ImageUtils.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void writeJpg(@Nonnull Image image, @Nonnull OutputStream out) throws IOException {
        ImageUtils.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(@Nonnull Image image, @Nonnull OutputStream out) throws IOException {
        ImageUtils.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(@Nonnull ImageInputStream srcStream, @Nullable String formatName, @Nonnull ImageOutputStream destStream) throws IOException {
        ImageUtils.write((Image)ImageUtils.read(srcStream), formatName, destStream);
    }

    public static void write(@Nonnull Image image, @Nullable String imageType, @Nonnull OutputStream out) throws IOException {
        ImageUtils.write(image, imageType, ImageUtils.getImageOutputStream(out));
    }

    public static boolean write(@Nonnull Image image, @Nullable String imageType, @Nonnull ImageOutputStream destImageStream) throws IOException {
        return ImageUtils.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(@Nonnull Image image, @Nullable String imageType, @Nonnull ImageOutputStream destImageStream, float quality) throws IOException {
        if (Strings.isNullOrEmpty((String)imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        BufferedImage bufferedImage = ImageUtils.toBufferedImage(image, imageType);
        ImageWriter writer = ImageUtils.getWriter(bufferedImage, imageType);
        return ImageUtils.write((Image)bufferedImage, writer, destImageStream, quality);
    }

    public static void write(@Nonnull Image image, @Nonnull File targetFile) throws IOException {
        ImageUtils.touch(targetFile);
        try (ImageOutputStream out = ImageUtils.getImageOutputStream(targetFile);){
            String ext = FilenameUtils.getExtension((String)targetFile.getName());
            ImageUtils.write(image, ext, out);
        }
    }

    public static File touch(@Nullable File file) throws IOException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            boolean ret = file.mkdirs();
            file.createNewFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(@Nonnull Image image, @Nullable ImageWriter writer, @Nonnull ImageOutputStream output, float quality) throws IOException {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImageUtils.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(@Nonnull String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(@Nonnull String imageFilePath) throws IOException {
        return ImageUtils.read(new File(imageFilePath));
    }

    public static BufferedImage read(@Nonnull File imageFile) throws IOException {
        BufferedImage result = ImageIO.read(imageFile);
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static Image getImage(@Nonnull URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static BufferedImage read(@Nonnull InputStream imageStream) throws IOException {
        BufferedImage result = ImageIO.read(imageStream);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(@Nonnull ImageInputStream imageStream) throws IOException {
        BufferedImage result = ImageIO.read(imageStream);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(@Nonnull URL imageUrl) throws IOException {
        BufferedImage result = ImageIO.read(imageUrl);
        if (null == result) {
            throw new IllegalArgumentException("Image type of [" + imageUrl + "] is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(@Nonnull OutputStream out) throws IOException {
        ImageOutputStream result = ImageIO.createImageOutputStream(out);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(@Nonnull File outFile) throws IOException {
        ImageOutputStream result = ImageIO.createImageOutputStream(outFile);
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static ImageInputStream getImageInputStream(@Nonnull InputStream in) throws IOException {
        ImageOutputStream result = ImageIO.createImageOutputStream(in);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageWriter getWriter(@Nonnull Image img, @Nonnull String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImageUtils.toBufferedImage(img, formatName));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(@Nonnull String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(@Nonnull Color color) {
        return ImageUtils.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String toHex(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static Color hexToColor(@Nonnull String hex) {
        String prefix = "#";
        return ImageUtils.getColor(Integer.parseInt(hex.startsWith("#") ? hex.substring(hex.length() + 1) : hex, 16));
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(@Nonnull String colorName) {
        if (Strings.isNullOrEmpty((String)colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARKGRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ImageUtils.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ImageUtils.hexToColor("#ac9c85");
        }
        if (colorName.startsWith("#")) {
            return ImageUtils.hexToColor(colorName);
        }
        if (colorName.startsWith("$")) {
            return ImageUtils.hexToColor("#" + colorName.substring(1));
        }
        String[] rgb = colorName.split(",");
        if (3 == rgb.length) {
            int r = Integer.parseInt(rgb[0]);
            int g = Integer.parseInt(rgb[1]);
            int b = Integer.parseInt(rgb[2]);
            return new Color(r, g, b);
        }
        return null;
    }

    public static Color randomColor() {
        return ImageUtils.randomColor(null);
    }

    public static Color randomColor(@Nullable Random random) {
        if (null == random) {
            random = ThreadLocalRandom.current();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Point getPointBaseCentre(@Nonnull Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle.x + Math.abs(backgroundWidth - rectangle.width) / 2, rectangle.y + Math.abs(backgroundHeight - rectangle.height) / 2);
    }

    public static String getMainColor(@Nonnull BufferedImage image, int[] ... rgbFilters) {
        HashMap countMap = Maps.newHashMap();
        int width = image.getWidth();
        int height = image.getHeight();
        int minx = image.getMinX();
        int miny = image.getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int b;
                int g;
                int pixel = image.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                if (ImageUtils.matchFilters(r, g = (pixel & 0xFF00) >> 8, b = pixel & 0xFF, rgbFilters)) continue;
                countMap.merge(r + "-" + g + "-" + b, 1L, Long::sum);
            }
        }
        String maxColor = null;
        long maxCount = 0L;
        for (Map.Entry entry : countMap.entrySet()) {
            String key = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= maxCount) continue;
            maxColor = key;
            maxCount = count;
        }
        String[] splitRgbStr = maxColor == null ? new String[3] : maxColor.split("-");
        String rHex = Integer.toHexString(Integer.parseInt(splitRgbStr[0]));
        String gHex = Integer.toHexString(Integer.parseInt(splitRgbStr[1]));
        String bHex = Integer.toHexString(Integer.parseInt(splitRgbStr[2]));
        rHex = rHex.length() == 1 ? "0" + rHex : rHex;
        gHex = gHex.length() == 1 ? "0" + gHex : gHex;
        bHex = bHex.length() == 1 ? "0" + bHex : bHex;
        return "#" + rHex + gHex + bHex;
    }

    private static boolean matchFilters(int r, int g, int b, int[] ... rgbFilters) {
        if (rgbFilters != null) {
            for (int[] rgbFilter : rgbFilters) {
                if (r != rgbFilter[0] || g != rgbFilter[1] || b != rgbFilter[2]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean backgroundRemoval(@Nonnull String inputPath, @Nonnull String outputPath, int tolerance) throws IOException {
        return BackgroundRemoval.backgroundRemoval(inputPath, outputPath, tolerance);
    }

    public static boolean backgroundRemoval(@Nonnull File input, @Nonnull File output, int tolerance) throws IOException {
        return BackgroundRemoval.backgroundRemoval(input, output, tolerance);
    }

    public static boolean backgroundRemoval(@Nonnull File input, @Nonnull File output, @Nullable Color override, int tolerance) throws IOException {
        return BackgroundRemoval.backgroundRemoval(input, output, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(@Nonnull BufferedImage bufferedImage, @Nonnull Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(bufferedImage, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(@Nonnull ByteArrayOutputStream outputStream, @Nonnull Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(outputStream, override, tolerance);
    }

    public static BufferedImage colorConvert(@Nonnull ColorSpace colorSpace, @Nonnull BufferedImage image) {
        return ImageUtils.filter(new ColorConvertOp(colorSpace, null), image);
    }

    public static BufferedImage transform(@Nonnull AffineTransform xform, @Nonnull BufferedImage image) {
        return ImageUtils.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(@Nonnull BufferedImageOp op, @Nonnull BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(@Nonnull ImageFilter filter, @Nonnull Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
    }
}

