/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.data.repository.impl;

import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import top.zenyoung.common.paging.PagingQuery;
import top.zenyoung.common.paging.PagingResult;
import top.zenyoung.data.jpa.JpaBase;

public abstract class BaseRepositoryImpl {
    private static final Logger log = LoggerFactory.getLogger(BaseRepositoryImpl.class);
    private static final int DEF_PAGING_IDX = 0;
    private static final int DEF_PAGING_ROWS = 10;

    protected <Qry extends Serializable, Item, Ret extends Serializable> PagingResult<Ret> buildPagingQuery(@Nullable PagingQuery<Qry> pagingQuery, @Nonnull PagingQueryHandler<Qry, Item, Ret> handler) {
        Page<Item> page;
        int idx = 0;
        int rows = 10;
        Predicate predicate = null;
        if (pagingQuery != null) {
            int n = idx = pagingQuery.getIndex() == null ? 0 : pagingQuery.getIndex() - 1;
            if (idx < 0) {
                idx = 0;
            }
            int n2 = rows = pagingQuery.getRows() == null ? 0 : pagingQuery.getRows();
            if (rows <= 0) {
                rows = 10;
            }
            predicate = handler.queryConvert(pagingQuery.getQuery());
        }
        if ((page = handler.queryData(predicate, (Pageable)PageRequest.of((int)idx, (int)rows, (Sort)handler.orderBy()))) != null) {
            final long totals = page.getTotalElements();
            final List items = page.getContent().stream().filter(Objects::nonNull).map(handler).filter(Objects::nonNull).collect(Collectors.toList());
            return new PagingResult<Ret>(){

                public Long getTotal() {
                    return totals;
                }

                public List<Ret> getRows() {
                    return items;
                }
            };
        }
        return null;
    }

    protected <Qry extends Serializable, Item, Ret extends Serializable> PagingResult<Ret> buildPagingQuery(@Nullable PagingQuery<Qry> pagingQuery, final @Nonnull Function<Qry, Predicate> queryConvert, final @Nullable Supplier<Sort> orderByHandler, final @Nonnull JpaBase<Item, ?> jpaRepository, final @Nonnull Function<Item, Ret> entityConvert) {
        return this.buildPagingQuery(pagingQuery, new PagingQueryHandler<Qry, Item, Ret>(){

            @Override
            public Predicate queryConvert(@Nullable Qry qry) {
                return (Predicate)queryConvert.apply(qry);
            }

            @Override
            public Sort orderBy() {
                return orderByHandler == null ? Sort.unsorted() : (Sort)orderByHandler.get();
            }

            @Override
            public Page<Item> queryData(@Nullable Predicate predicate, @Nonnull Pageable pageable) {
                return predicate == null ? jpaRepository.findAll(pageable) : jpaRepository.findAll(predicate, pageable);
            }

            @Override
            public Ret apply(Item item) {
                return (Serializable)entityConvert.apply(item);
            }
        });
    }

    protected <Qry extends Serializable, Item, Ret extends Serializable> PagingResult<Ret> buildPagingQuery(@Nullable PagingQuery<Qry> pagingQuery, @Nonnull Function<Qry, Predicate> queryConvert, @Nonnull JpaBase<Item, ?> jpaRepository, @Nonnull Function<Item, Ret> entityConvert) {
        return this.buildPagingQuery(pagingQuery, queryConvert, null, jpaRepository, entityConvert);
    }

    protected static interface PagingQueryHandler<Qry extends Serializable, Item, Ret extends Serializable>
    extends Function<Item, Ret> {
        public Predicate queryConvert(@Nullable Qry var1);

        default public Sort orderBy() {
            return Sort.unsorted();
        }

        public Page<Item> queryData(@Nullable Predicate var1, @Nonnull Pageable var2);
    }
}

