/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.security.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.util.CollectionUtils;

public class UserPrincipal
implements Serializable {
    private String id;
    private String account;
    private List<String> roles;
    private final Map<String, Serializable> exts = Maps.newLinkedHashMap();

    public UserPrincipal(String id, String account, List<String> roles, Map<String, Serializable> exts) {
        this.id = id;
        this.account = account;
        this.roles = roles;
        if (!CollectionUtils.isEmpty(exts)) {
            this.exts.putAll(exts);
        }
    }

    public UserPrincipal(String id, String account, List<String> roles) {
        this(id, account, roles, null);
    }

    public UserPrincipal(@Nonnull UserPrincipal principal) {
        this(principal.getId(), principal.getAccount(), principal.getRoles(), principal.getExts());
    }

    public UserPrincipal() {
        this(null, null, Lists.newLinkedList(), Maps.newLinkedHashMap());
    }

    public void add(@Nonnull String key, @Nonnull Serializable val) {
        this.getExts().put(key, val);
    }

    public <T extends Serializable> T getVal(@Nonnull String key, @Nonnull Class<T> dataClass) {
        Serializable obj = this.getExts().getOrDefault(key, null);
        if (obj != null) {
            return (T)((Serializable)dataClass.cast(obj));
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, Serializable> getExts() {
        return this.exts;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPrincipal)) {
            return false;
        }
        UserPrincipal other = (UserPrincipal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Map<String, Serializable> this$exts = this.getExts();
        Map<String, Serializable> other$exts = other.getExts();
        return !(this$exts == null ? other$exts != null : !((Object)this$exts).equals(other$exts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserPrincipal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Map<String, Serializable> $exts = this.getExts();
        result = result * 59 + ($exts == null ? 43 : ((Object)$exts).hashCode());
        return result;
    }

    public String toString() {
        return "UserPrincipal(id=" + this.getId() + ", account=" + this.getAccount() + ", roles=" + this.getRoles() + ", exts=" + this.getExts() + ")";
    }
}

