/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.security.token;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zenyoung.common.util.CacheUtils;
import top.zenyoung.security.exception.TokenException;
import top.zenyoung.security.token.Ticket;
import top.zenyoung.security.token.TokenGenerator;

public class JwtTokenGenerator
implements TokenGenerator {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenGenerator.class);
    private static final Duration DEF_EXPIRE = Duration.ofMinutes(30L);
    private static final String DEF_SIGN_SLAT = JwtTokenGenerator.class.getName();
    private static final Cache<String, SecretKey> SECRET_KEY_CACHE = CacheUtils.createCache();
    private Duration expire;
    private String signSlat;

    private static SecretKey generalKey(@Nonnull String key) {
        log.debug("generalKey(key: {})...", (Object)key);
        return (SecretKey)CacheUtils.getCacheValue(SECRET_KEY_CACHE, (Object)key, () -> {
            byte[] encodeKey = Base64.encodeBase64((byte[])(key + DEF_SIGN_SLAT).getBytes(StandardCharsets.UTF_8));
            return new SecretKeySpec(encodeKey, 0, encodeKey.length, "AES");
        });
    }

    @Override
    public String createToken(@Nonnull Ticket ticket) {
        try {
            String slat = this.getSignSlat();
            SecretKey secretKey = JwtTokenGenerator.generalKey(Strings.isNullOrEmpty((String)slat) ? DEF_SIGN_SLAT : slat);
            int timeout = (int)(this.getExpire() == null ? DEF_EXPIRE : this.getExpire()).getSeconds();
            Date start = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            calendar.add(13, timeout);
            return Jwts.builder().setId(UUID.randomUUID().toString()).addClaims(ticket.toClaims()).setIssuedAt(start).setNotBefore(start).setExpiration(calendar.getTime()).signWith(SignatureAlgorithm.HS512, (Key)secretKey).compact();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Ticket parseToken(@Nonnull String token) throws TokenException {
        log.debug("parseToken(token: {})...", (Object)token);
        if (Strings.isNullOrEmpty((String)token)) {
            throw new TokenException("\u4ee4\u724c\u4e3a\u7a7a!");
        }
        try {
            String slat = this.getSignSlat();
            SecretKey secretKey = JwtTokenGenerator.generalKey(Strings.isNullOrEmpty((String)slat) ? DEF_SIGN_SLAT : slat);
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(token).getBody();
            return Ticket.create((Map<String, Object>)claims);
        }
        catch (Throwable ex) {
            throw new TokenException(ex);
        }
    }

    public static JwtTokenGeneratorBuilder builder() {
        return new JwtTokenGeneratorBuilder();
    }

    @Override
    public Duration getExpire() {
        return this.expire;
    }

    @Override
    public String getSignSlat() {
        return this.signSlat;
    }

    public void setExpire(Duration expire) {
        this.expire = expire;
    }

    public void setSignSlat(String signSlat) {
        this.signSlat = signSlat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtTokenGenerator)) {
            return false;
        }
        JwtTokenGenerator other = (JwtTokenGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Duration this$expire = this.getExpire();
        Duration other$expire = other.getExpire();
        if (this$expire == null ? other$expire != null : !((Object)this$expire).equals(other$expire)) {
            return false;
        }
        String this$signSlat = this.getSignSlat();
        String other$signSlat = other.getSignSlat();
        return !(this$signSlat == null ? other$signSlat != null : !this$signSlat.equals(other$signSlat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtTokenGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Duration $expire = this.getExpire();
        result = result * 59 + ($expire == null ? 43 : ((Object)$expire).hashCode());
        String $signSlat = this.getSignSlat();
        result = result * 59 + ($signSlat == null ? 43 : $signSlat.hashCode());
        return result;
    }

    public String toString() {
        return "JwtTokenGenerator(expire=" + this.getExpire() + ", signSlat=" + this.getSignSlat() + ")";
    }

    public JwtTokenGenerator() {
    }

    public JwtTokenGenerator(Duration expire, String signSlat) {
        this.expire = expire;
        this.signSlat = signSlat;
    }

    public static class JwtTokenGeneratorBuilder {
        private Duration expire;
        private String signSlat;

        JwtTokenGeneratorBuilder() {
        }

        public JwtTokenGeneratorBuilder expire(Duration expire) {
            this.expire = expire;
            return this;
        }

        public JwtTokenGeneratorBuilder signSlat(String signSlat) {
            this.signSlat = signSlat;
            return this;
        }

        public JwtTokenGenerator build() {
            return new JwtTokenGenerator(this.expire, this.signSlat);
        }

        public String toString() {
            return "JwtTokenGenerator.JwtTokenGeneratorBuilder(expire=" + this.expire + ", signSlat=" + this.signSlat + ")";
        }
    }
}

