/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.security.token;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import top.zenyoung.security.model.UserPrincipal;

public class Ticket
extends UserPrincipal {
    private static final String KEY_ID = "id";
    private static final String KEY_ACCOUNT = "account";
    private static final String KEY_ROLES = "roles";
    private static final String SEP_ROLE = ",";

    public Ticket(@Nonnull UserPrincipal principal) {
        super(principal);
    }

    public Map<String, Object> toClaims() {
        return new HashMap<String, Object>(3){
            {
                this.put(Ticket.KEY_ID, Ticket.this.getId());
                this.put(Ticket.KEY_ACCOUNT, Ticket.this.getAccount());
                List<String> roles = Ticket.this.getRoles();
                this.put(Ticket.KEY_ROLES, roles == null || roles.size() == 0 ? null : Joiner.on((String)Ticket.SEP_ROLE).skipNulls().join(roles));
            }
        };
    }

    public static Ticket create(@Nonnull Map<String, Object> claims) {
        Ticket ticket = new Ticket();
        if (claims.size() > 0) {
            ticket.setId(Ticket.convert(KEY_ID, claims, Object::toString));
            ticket.setAccount(Ticket.convert(KEY_ACCOUNT, claims, Object::toString));
            ticket.setRoles(Ticket.convert(KEY_ROLES, claims, obj -> {
                String roles = obj.toString();
                if (!Strings.isNullOrEmpty((String)roles)) {
                    return Splitter.on((String)SEP_ROLE).omitEmptyStrings().trimResults().splitToList((CharSequence)roles);
                }
                return null;
            }));
        }
        return ticket;
    }

    private static <T> T convert(@Nonnull String key, @Nonnull Map<String, Object> data, @Nonnull Function<Object, T> handler) {
        Object obj;
        if (!Strings.isNullOrEmpty((String)key) && (obj = data.getOrDefault(key, null)) != null) {
            return handler.apply(obj);
        }
        return null;
    }

    @Override
    public String toString() {
        return "Ticket()";
    }

    public Ticket() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ticket)) {
            return false;
        }
        Ticket other = (Ticket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Ticket;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

