/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.websocket;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.WebSocketHandler;
import top.zenyoung.websocket.WebSocketMapping;

public class WebSocketHandlerMapping
extends SimpleUrlHandlerMapping {
    private final Map<String, WebSocketHandler> handlerMap = Maps.newLinkedHashMap();

    public void initApplicationContext() throws BeansException {
        Map beanMaps = this.obtainApplicationContext().getBeansWithAnnotation(WebSocketMapping.class);
        if (!CollectionUtils.isEmpty((Map)beanMaps)) {
            beanMaps.values().forEach(bean -> {
                if (!(bean instanceof WebSocketHandler)) {
                    throw new RuntimeException(String.format("Controller [%s] doesn't implement WebSocketHandler interface.", bean.getClass().getName()));
                }
                WebSocketMapping annotation = (WebSocketMapping)AnnotationUtils.getAnnotation(bean.getClass(), WebSocketMapping.class);
                this.handlerMap.put(Objects.requireNonNull(annotation).value(), (WebSocketHandler)bean);
            });
        }
        this.setOrder(Integer.MIN_VALUE);
        this.setUrlMap(this.handlerMap);
        super.initApplicationContext();
    }
}

