/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.FluxSink;

public class WebSocketSender
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WebSocketSender.class);
    private final WebSocketSession session;
    private final FluxSink<WebSocketMessage> sink;

    public WebSocketSender(@Nonnull WebSocketSession session, @Nonnull FluxSink<WebSocketMessage> sink) {
        this.session = session;
        this.sink = sink;
    }

    public void sendData(@Nonnull String data) {
        this.sink.next((Object)this.session.textMessage(data));
    }

    public <T> void sendJsonData(@Nonnull ObjectMapper objectMapper, @Nonnull T data) {
        log.debug("sendJsonData(objectMapper: {},data: {})...", (Object)objectMapper, data);
        try {
            this.sendData(objectMapper.writeValueAsString(data));
        }
        catch (Throwable ex) {
            log.error("sendJsonData(objectMapper: {},data: {})-exp: {}", new Object[]{objectMapper, data, ex.getMessage()});
        }
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    public FluxSink<WebSocketMessage> getSink() {
        return this.sink;
    }
}

