/*
 * Decompiled with CFR 0.152.
 */
package top.zenyoung.websocket;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import top.zenyoung.websocket.WebSocketSender;
import top.zenyoung.websocket.WebSocketUserManager;

public class WebSocketUserManagerMemory
implements WebSocketUserManager {
    private static final Logger log = LoggerFactory.getLogger(WebSocketUserManagerMemory.class);
    private static final Map<String, Object> LOCKS = Maps.newConcurrentMap();
    private final Map<String, Map<String, List<WebSocketSender>>> groupSenders = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketSender put(@Nonnull String groupKey, @Nonnull String key, @Nonnull WebSocketSender sender) {
        log.debug("put(groupKey: {},key: {},sender: {})...", new Object[]{groupKey, key, sender});
        Assert.hasText((String)groupKey, (String)"'groupKey'\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)key, (String)"'key'\u4e0d\u80fd\u4e3a\u7a7a!");
        String lock = "put:" + key;
        Object object = LOCKS.computeIfAbsent(lock, k -> new Object());
        synchronized (object) {
            try {
                Map mapWeakSenders = this.groupSenders.computeIfAbsent(groupKey, k -> Maps.newConcurrentMap());
                List listWeakSenders = mapWeakSenders.computeIfAbsent(key, k -> Lists.newCopyOnWriteArrayList());
                listWeakSenders.add(sender);
            }
            finally {
                LOCKS.remove(lock);
            }
        }
        return sender;
    }

    @Override
    public int size(@Nonnull String groupKey) {
        log.debug("size(groupKey: {})...", (Object)groupKey);
        Assert.hasText((String)groupKey, (String)"'groupKey'\u4e0d\u80fd\u4e3a\u7a7a!");
        Map<String, List<WebSocketSender>> mapSenders = this.groupSenders.get(groupKey);
        if (!CollectionUtils.isEmpty(mapSenders)) {
            return mapSenders.values().stream().mapToInt(List::size).sum();
        }
        return 0;
    }

    @Override
    public List<WebSocketSender> get(@Nonnull String groupKey, @Nonnull String key) {
        log.debug("get(groupKey: {},key: {})...", (Object)groupKey, (Object)key);
        Assert.hasText((String)groupKey, (String)"'groupKey'\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)key, (String)"'key'\u4e0d\u80fd\u4e3a\u7a7a!");
        Map<String, List<WebSocketSender>> mapSenders = this.groupSenders.get(groupKey);
        if (!CollectionUtils.isEmpty(mapSenders)) {
            return mapSenders.get(key);
        }
        return null;
    }

    @Override
    public List<WebSocketSender> remove(@Nonnull String groupKey, @Nonnull String key) {
        log.debug("remove(groupKey: {},key: {})...", (Object)groupKey, (Object)key);
        Assert.hasText((String)groupKey, (String)"'groupKey'\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)key, (String)"'key'\u4e0d\u80fd\u4e3a\u7a7a!");
        Map<String, List<WebSocketSender>> mapSenders = this.groupSenders.get(groupKey);
        if (!CollectionUtils.isEmpty(mapSenders)) {
            return mapSenders.remove(key);
        }
        return null;
    }

    @Override
    public void remove(@Nonnull String groupKey, @Nonnull String key, @Nonnull WebSocketSender sender) {
        List<WebSocketSender> weakSenders;
        log.debug("remove(groupKey: {},key: {},sender: {})...", new Object[]{groupKey, key, sender});
        Map<String, List<WebSocketSender>> mapSenders = this.groupSenders.get(groupKey);
        if (!CollectionUtils.isEmpty(mapSenders) && !CollectionUtils.isEmpty(weakSenders = mapSenders.get(key))) {
            weakSenders.stream().filter(s -> s != null && s.equals(sender)).findFirst().ifPresent(weakSenders::remove);
        }
    }

    @Override
    public void consumers(@Nonnull String groupKey, @Nonnull BiConsumer<String, List<WebSocketSender>> senderConsumer) {
        log.debug("consumers(groupKey: {},senderConsumer: {})...", (Object)groupKey, senderConsumer);
        Assert.hasText((String)groupKey, (String)"'groupKey'\u4e0d\u80fd\u4e3a\u7a7a!");
        Map<String, List<WebSocketSender>> mapSenders = this.groupSenders.get(groupKey);
        if (!CollectionUtils.isEmpty(mapSenders)) {
            mapSenders.forEach(senderConsumer);
        }
    }
}

