/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.distributed.lock;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zopx.square.distributed.core.exception.BusException;
import top.zopx.square.distributed.lock.BaseLock;

public class ZkLock
extends BaseLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkLock.class);
    private final String lockPath;
    private final CuratorFramework client;
    private InterProcessLock lock;

    public ZkLock(CuratorFramework client, String lockPath) {
        this.client = client;
        this.lockPath = lockPath;
    }

    public void lock() {
        try {
            this.lock.acquire();
        }
        catch (Exception e) {
            LOGGER.error("Lock\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new BusException(e);
        }
    }

    public boolean tryLock() {
        boolean isLocked;
        try {
            isLocked = this.lock.acquire(0L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("tryLock\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new BusException(e);
        }
        return isLocked;
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        boolean isLocked;
        try {
            isLocked = this.lock.acquire(time, unit);
        }
        catch (Exception e) {
            LOGGER.error("tryLock\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new BusException(e);
        }
        return isLocked;
    }

    public void unlock() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            LOGGER.error("unlock\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new BusException(e);
        }
    }

    public void init() {
        this.lock = this.defaultLock(this.lockPath);
    }

    InterProcessLock defaultLock(String lockPath) {
        return new InterProcessMutex(this.client, lockPath);
    }
}

