/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.configurator.parse;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyClientAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClientAcceptor.class);
    private static final ThreadFactory THREAD_FACTORY = r -> new Thread(r, "square-client-work");
    private static final EpollEventLoopGroup EPOLL_EVENT_LOOP_GROUP = new EpollEventLoopGroup(THREAD_FACTORY);
    private static final NioEventLoopGroup NIO_EVENT_LOOP_GROUP = new NioEventLoopGroup(THREAD_FACTORY);
    private static final Gson GSON = new Gson();
    private final Config _usingConf;
    private Map<String, String> _extraInfoMap;
    private Channel _ch;
    private boolean _ready = false;

    public NettyClientAcceptor(Config usingConf) {
        if (null == usingConf) {
            throw new IllegalArgumentException("usingConf is null");
        }
        this._usingConf = usingConf;
    }

    public void putExtraInfo(String key, String val) {
        if (null == key) {
            return;
        }
        if (null == val && null == this._extraInfoMap) {
            return;
        }
        if (null == this._extraInfoMap) {
            this._extraInfoMap = new ConcurrentHashMap<String, String>();
        }
        this._extraInfoMap.put(key, val);
    }

    public boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux");
    }

    public void conn() {
        this.conn(null);
    }

    public void conn(EventLoopGroup work) {
        try {
            URI serverURI = new URI(MessageFormat.format("{0}://{1}:{2}/{3}", this._usingConf.getWsPrefix(), this._usingConf.getServerHost(), String.valueOf(this._usingConf.getServerPort()), this._usingConf.getPath()));
            DefaultHttpHeaders headerz = new DefaultHttpHeaders();
            if (null != this._extraInfoMap) {
                for (Map.Entry<String, String> entry : this._extraInfoMap.entrySet()) {
                    if (null == entry.getValue()) continue;
                    headerz.add(entry.getKey(), (Object)entry.getValue());
                }
            }
            final WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)serverURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)headerz);
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)(null == work ? (this.isLinux() ? EPOLL_EVENT_LOOP_GROUP : NIO_EVENT_LOOP_GROUP) : work));
            b.channel(null == work ? (this.isLinux() ? EpollSocketChannel.class : NioSocketChannel.class) : (work instanceof EpollEventLoopGroup ? EpollSocketChannel.class : NioSocketChannel.class));
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    Config.AbstractChannelHandlerFactory f = NettyClientAcceptor.this._usingConf.getChannelHandlerFactory();
                    ChannelHandler msgHandler = null;
                    if (null != f) {
                        msgHandler = f.createMsgHandler();
                    }
                    if (NettyClientAcceptor.this._usingConf.getServerType() == 2) {
                        ChannelHandler[] hArray;
                        for (ChannelHandler h : hArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(65535), new WebSocketClientProtocolHandler(handshaker), msgHandler}) {
                            if (null == h) continue;
                            ch.pipeline().addLast(new ChannelHandler[]{h});
                        }
                    } else {
                        ch.pipeline().addLast(new ChannelHandler[]{msgHandler});
                    }
                }
            });
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.connect(this._usingConf.getServerHost(), this._usingConf.getServerPort()).sync();
            if (!f.isSuccess()) {
                return;
            }
            this._ch = f.channel();
            this._ch.closeFuture().addListener(x -> {
                NettyClientAcceptor closeClient = this;
                LOGGER.warn("XXX \u6ce8\u610f: \u670d\u52a1\u5668\u8fde\u63a5\u5173\u95ed! {} XXX", (Object)this._usingConf);
                this._ready = false;
                closeClient._ch = null;
                ICloseCallback callback = this._usingConf.getCloseCallback();
                if (null != callback) {
                    callback.apply(closeClient);
                }
            });
            if (this._usingConf.getServerType() == 2) {
                CountDownLatch cdL = new CountDownLatch(32);
                while (cdL.getCount() > 0L && !handshaker.isHandshakeComplete()) {
                    cdL.await(200L, TimeUnit.MILLISECONDS);
                    cdL.countDown();
                }
                if (!handshaker.isHandshakeComplete()) {
                    return;
                }
            }
            LOGGER.info(">>> \u8fde\u63a5\u5230\u670d\u52a1\u5668\u6210\u529f! {} <<<", (Object)this._usingConf);
            this._ready = true;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void sendMsg(Object msgObj) {
        if (!this.isReady()) {
            LOGGER.error("\u5ba2\u6237\u7aef\u672a\u51c6\u5907\u597d");
            return;
        }
        if (null == this._ch) {
            LOGGER.error("client channel is null");
            return;
        }
        this._ch.writeAndFlush(msgObj);
    }

    public int getServerId() {
        return this._usingConf.getServerId();
    }

    public String getServerName() {
        return this._usingConf.getServerName();
    }

    public Set<String> getServerJobTypeSet() {
        return this._usingConf.getServerJobTypeSet();
    }

    public String getServerHost() {
        return this._usingConf.getServerHost();
    }

    public int getServerPort() {
        return this._usingConf.getServerPort();
    }

    public boolean isReady() {
        return this._ready;
    }

    public static final class Config {
        public static final int APP = 1;
        public static final int WS = 2;
        private int _serverType = 2;
        private int _serverId;
        private String _serverName;
        private Set<String> _serverJobTypeSet;
        private String _serverHost;
        private int _serverPort;
        private String _path = "ws";
        private Boolean _safe = false;
        @Expose(serialize=false, deserialize=false)
        private AbstractChannelHandlerFactory _channelHandlerFactory;
        @Expose(serialize=false, deserialize=false)
        private ICloseCallback _closeCallback;

        public String getWsPrefix() {
            return this._safe != false ? "wss" : "ws";
        }

        @SerializedName(value="path")
        public String getPath() {
            return this._path;
        }

        public void setPath(String path) {
            this._path = path;
        }

        @SerializedName(value="safe")
        public Boolean getSafe() {
            return this._safe;
        }

        public void setSafe(Boolean safe) {
            this._safe = safe;
        }

        @SerializedName(value="serverType")
        public int getServerType() {
            return this._serverType;
        }

        public void setServerType(int _serverType) {
            this._serverType = _serverType;
        }

        @SerializedName(value="serverId")
        public int getServerId() {
            return this._serverId;
        }

        public void setServerId(int val) {
            this._serverId = val;
        }

        @SerializedName(value="serverName")
        public String getServerName() {
            return this._serverName;
        }

        public void setServerName(String val) {
            this._serverName = val;
        }

        @SerializedName(value="serverJobTypeSet")
        public Set<String> getServerJobTypeSet() {
            if (CollectionUtils.isEmpty(this._serverJobTypeSet)) {
                return Collections.emptySet();
            }
            return this._serverJobTypeSet;
        }

        public void setServerJobTypeSet(Set<String> val) {
            this._serverJobTypeSet = val;
        }

        @SerializedName(value="serverHost")
        public String getServerHost() {
            return this._serverHost;
        }

        public void setServerHost(String val) {
            this._serverHost = val;
        }

        @SerializedName(value="serverPort")
        public int getServerPort() {
            return this._serverPort;
        }

        public void setServerPort(int val) {
            this._serverPort = val;
        }

        public AbstractChannelHandlerFactory getChannelHandlerFactory() {
            return this._channelHandlerFactory;
        }

        public void setChannelHandlerFactory(AbstractChannelHandlerFactory val) {
            this._channelHandlerFactory = val;
        }

        public ICloseCallback getCloseCallback() {
            return this._closeCallback;
        }

        public void setCloseCallback(ICloseCallback val) {
            this._closeCallback = val;
        }

        public String toString() {
            return MessageFormat.format("serverId = {0}, serverName = {1}, serverJobType = {2}, addr = {3}:{4}", String.valueOf(this._serverId), this._serverName, this._serverJobTypeSet, this._serverHost, String.valueOf(this._serverPort));
        }

        public static Config fromJSONObj(JsonObject jsonObj) {
            if (null == jsonObj) {
                return null;
            }
            return (Config)GSON.fromJson((JsonElement)jsonObj, Config.class);
        }

        public static abstract class AbstractChannelHandlerFactory {
            public abstract ChannelHandler createMsgHandler();
        }
    }

    public static interface ICloseCallback {
        public void apply(NettyClientAcceptor var1);
    }
}

