/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.configurator.parse;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zopx.square.netty.configurator.properties.NettyServerConfig;
import top.zopx.square.netty.handle.BaseChannelHandlerFactory;

public class NettyServerAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServerAcceptor.class);
    private final NettyServerConfig.App app;
    private final NettyServerConfig.Ws ws;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final int bossThreadPool;
    private final int workThreadPool;
    private EventLoopGroup appBoss;
    private EventLoopGroup appWork;
    private EventLoopGroup websocketBoss;
    private EventLoopGroup websocketWork;
    private final ThreadFactory bossFactory;
    private final ThreadFactory workFactory;
    private final BaseChannelHandlerFactory factory;

    private NettyServerAcceptor(Builder builder) {
        this.app = builder.app;
        this.ws = builder.ws;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.bossThreadPool = builder.bossThreadPool;
        this.workThreadPool = builder.workThreadPool;
        this.factory = builder.factory;
        this.bossFactory = r -> new Thread(r, "square-boss");
        this.workFactory = r -> new Thread(r, "square-work");
    }

    private void createAppEventLoopGroup() {
        if (this.isLinux()) {
            this.appBoss = new EpollEventLoopGroup(this.bossThreadPool, this.bossFactory);
            this.appWork = new EpollEventLoopGroup(this.workThreadPool, this.workFactory);
        } else {
            this.appBoss = new NioEventLoopGroup(this.bossThreadPool, this.bossFactory);
            this.appWork = new NioEventLoopGroup(this.workThreadPool, this.workFactory);
        }
    }

    private void createWebSocketEventLoopGroup() {
        if (this.isLinux()) {
            this.websocketBoss = new EpollEventLoopGroup(this.bossThreadPool, this.bossFactory);
            this.websocketWork = new EpollEventLoopGroup(this.workThreadPool, this.workFactory);
        } else {
            this.websocketBoss = new NioEventLoopGroup(this.bossThreadPool, this.bossFactory);
            this.websocketWork = new NioEventLoopGroup(this.workThreadPool, this.workFactory);
        }
    }

    public void destory(EventLoopGroup boss, EventLoopGroup work) {
        if (null != boss && !boss.isShutdown() && !boss.isShuttingDown()) {
            boss.shutdownGracefully();
        }
        if (null != work && !work.isShutdown() && !work.isShuttingDown()) {
            work.shutdownGracefully();
        }
    }

    public void destory() {
        this.destory(this.appBoss, this.appWork);
        this.destory(this.websocketBoss, this.websocketWork);
    }

    public void start() {
        if (null == this.factory) {
            throw new RuntimeException("HandleFactory\u5904\u7406\u5668\u5f02\u5e38");
        }
        if (null != this.app) {
            this.bindAppServer();
        }
        if (null != this.ws) {
            this.bindWebsocketServer();
        }
    }

    private void bindWebsocketServer() {
        this.createWebSocketEventLoopGroup();
        String path = StringUtils.isBlank((CharSequence)this.ws.getPath()) ? "/ws" : this.ws.getPath();
        ChannelFuture channelFuture = this.createServerBootstrap(this.ws.getHost(), this.ws.getPort(), ch -> {
            ChannelHandler[] handlers;
            LOGGER.info("WS Server init Handler");
            ChannelHandler msgHandler = this.factory.createWSMsgHandler();
            for (ChannelHandler h : handlers = new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(65535), new WebSocketServerProtocolHandler(path, false), new ChunkedWriteHandler(), msgHandler, new IdleStateHandler(this.readTimeout.getSeconds(), this.writeTimeout.getSeconds(), 0L, TimeUnit.SECONDS), new LoggingHandler(LogLevel.INFO)}) {
                if (null == h) continue;
                ch.pipeline().addLast(new ChannelHandler[]{h});
            }
        }, this.websocketBoss, this.websocketWork);
        Channel serverChannel = channelFuture.channel();
        serverChannel.newSucceededFuture().addListener(future -> {
            String log = "\n_____________________________________________________________________\n                                                                   \n   WebSocket\u670d\u52a1\u542f\u52a8\u6210\u529f,\u7ed1\u5b9a\u8bbe\u7f6e\uff1a\u3010ws://{}:{}{}\u3011                                 \n_____________________________________________________________________";
            LOGGER.info(log, new Object[]{this.ws.getHost(), this.ws.getPort(), path});
        });
        serverChannel.closeFuture().addListener(future -> this.destory(this.websocketBoss, this.websocketWork));
    }

    private void bindAppServer() {
        this.createAppEventLoopGroup();
        ChannelFuture channelFuture = this.createServerBootstrap(this.app.getHost(), this.app.getPort(), ch -> {
            ChannelHandler[] handlers;
            LOGGER.info("App Server init Handler");
            ChannelHandler msgHandler = this.factory.createAppMsgHandler();
            for (ChannelHandler h : handlers = new ChannelHandler[]{msgHandler, new IdleStateHandler(this.readTimeout.getSeconds(), this.writeTimeout.getSeconds(), 0L, TimeUnit.SECONDS), new LoggingHandler(LogLevel.INFO)}) {
                if (null == h) continue;
                ch.pipeline().addLast(new ChannelHandler[]{h});
            }
        }, this.appBoss, this.appWork);
        Channel serverChannel = channelFuture.channel();
        serverChannel.newSucceededFuture().addListener(future -> {
            String log = "\n_____________________________________________________________________\n                                                                 \n   App\u670d\u52a1\u542f\u52a8\u6210\u529f,\u7ed1\u5b9a\u5730\u5740\uff1a\u3010{}:{}\u3011                                  \n_____________________________________________________________________";
            LOGGER.info(log, (Object)this.app.getHost(), (Object)this.app.getPort());
        });
        serverChannel.closeFuture().addListener(future -> this.destory(this.appBoss, this.appWork));
    }

    private ChannelFuture createServerBootstrap(String host, int port, final Consumer<SocketChannel> consumer, EventLoopGroup boss, EventLoopGroup work) {
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(boss, work).channel(this.getServerChannel())).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                consumer.accept(ch);
            }
        }).bind(host, port).syncUninterruptibly();
    }

    private Class<? extends ServerChannel> getServerChannel() {
        return this.isLinux() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    public boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux");
    }

    public static class Builder {
        NettyServerConfig.App app;
        NettyServerConfig.Ws ws;
        private Duration readTimeout;
        private Duration writeTimeout;
        private int bossThreadPool;
        private int workThreadPool;
        private BaseChannelHandlerFactory factory;

        public Builder setApp(NettyServerConfig.App app) {
            this.app = app;
            return this;
        }

        public Builder setWs(NettyServerConfig.Ws ws) {
            this.ws = ws;
            return this;
        }

        public Builder setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setBossThreadPool(int bossThreadPool) {
            this.bossThreadPool = bossThreadPool;
            return this;
        }

        public Builder setWorkThreadPool(int workThreadPool) {
            this.workThreadPool = workThreadPool;
            return this;
        }

        public Builder setFactory(BaseChannelHandlerFactory factory) {
            this.factory = factory;
            return this;
        }

        public NettyServerAcceptor build() {
            return new NettyServerAcceptor(this);
        }
    }
}

