/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.executor;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncOperationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncOperationProcessor.class);
    private final ExecutorService[] esArray;

    public AsyncOperationProcessor() {
        this(null, 0);
    }

    public AsyncOperationProcessor(String processorName, int threadCount) {
        if (null == processorName) {
            processorName = "AsyncOperationProcessor";
        }
        if (threadCount <= 0) {
            threadCount = Runtime.getRuntime().availableProcessors() * 2;
        }
        this.esArray = new ExecutorService[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            String threadName = processorName + "[" + i + "]";
            this.esArray[i] = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r);
                t.setName(threadName);
                return t;
            });
        }
    }

    public void process(int bindId, Runnable op, Executor exec, Runnable co) {
        if (null == op) {
            return;
        }
        bindId = Math.abs(bindId);
        int esIndex = bindId % this.esArray.length;
        this.esArray[esIndex].submit(() -> {
            try {
                op.run();
                if (null != exec && null != co) {
                    exec.execute(co);
                }
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        });
    }

    public void process(int bindId, Runnable op) {
        this.process(bindId, op, null, null);
    }
}

