/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.executor;

import com.google.protobuf.GeneratedMessageV3;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zopx.square.netty.executor.BaseCmdHandlerFactory;
import top.zopx.square.netty.handle.ICmdHandler;

public final class MainThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainThreadPoolExecutor.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setName(threadName);
        return t;
    });
    private final BaseCmdHandlerFactory factory;

    public MainThreadPoolExecutor(String threadName, BaseCmdHandlerFactory factory) {
        this.factory = factory;
    }

    public void process(ChannelHandlerContext ctx, GeneratedMessageV3 cmdMsg) {
        if (null == ctx || null == cmdMsg) {
            return;
        }
        this.process(() -> {
            Class<?> cmdClazz = cmdMsg.getClass();
            ICmdHandler<? extends GeneratedMessageV3> cmdHandler = this.factory.create(cmdClazz);
            if (null == cmdHandler) {
                LOGGER.error("\u672a\u627e\u5230\u547d\u4ee4\u5904\u7406\u5668, cmdClazz = {}", cmdClazz);
                return;
            }
            LOGGER.debug("\u5904\u7406\u547d\u4ee4, cmdClazz = {}", (Object)cmdClazz.getName());
            cmdHandler.cmd(ctx, (GeneratedMessageV3)this.cast(cmdMsg));
        });
    }

    private <T extends GeneratedMessageV3> T cast(GeneratedMessageV3 cmdMsg) {
        GeneratedMessageV3 tempObj = cmdMsg;
        return (T)tempObj;
    }

    public void process(Runnable runnable) {
        if (null != runnable) {
            this.executorService.submit(new SafeRunner(runnable));
        }
    }

    public void process(ChannelHandlerContext ctx, String sessionId, String fromUserId, GeneratedMessageV3 cmdMsg) {
        if (null == ctx || null == cmdMsg) {
            return;
        }
        this.process(() -> {
            Class<?> cmdClazz = cmdMsg.getClass();
            ICmdHandler<? extends GeneratedMessageV3> cmdHandler = this.factory.create(cmdClazz);
            if (null == cmdHandler) {
                LOGGER.error("\u672a\u627e\u5230\u547d\u4ee4\u5904\u7406\u5668, cmdClazz = {}", cmdClazz);
                return;
            }
            LOGGER.debug("\u5904\u7406\u547d\u4ee4, cmdClazz = {}", (Object)cmdClazz.getName());
            cmdHandler.cmd(ctx, (GeneratedMessageV3)this.cast(cmdMsg), sessionId, fromUserId);
        });
    }

    private static class SafeRunner
    implements Runnable {
        private final Runnable innerR;

        SafeRunner(Runnable innerR) {
            this.innerR = innerR;
        }

        @Override
        public void run() {
            if (null == this.innerR) {
                return;
            }
            try {
                this.innerR.run();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

