/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.msgGenRecognizer;

import com.google.protobuf.GeneratedMessageV3;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zopx.square.netty.handle.ICmdHandler;
import top.zopx.square.netty.util.PackageUtil;

public final class HandleGenMsgRecognizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleGenMsgRecognizer.class);
    private static final Map<Class<?>, ICmdHandler<? extends GeneratedMessageV3>> CLASS_HANDLE_MAP = new ConcurrentHashMap(128);

    private HandleGenMsgRecognizer() {
    }

    public static HandleGenMsgRecognizer getInstance() {
        return Holder.INSTANCE;
    }

    public Map<Class<?>, ICmdHandler<? extends GeneratedMessageV3>> getClassHandleMap(String packageName) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return CLASS_HANDLE_MAP;
        }
        try {
            List<Class<?>> fileList = PackageUtil.INSTANCE.getFileList(packageName, ICmdHandler.class, true);
            if (CollectionUtils.isEmpty(fileList)) {
                return CLASS_HANDLE_MAP;
            }
            for (Class<?> handler : fileList) {
                Class<?> parameterType = null;
                for (Method method : handler.getDeclaredMethods()) {
                    Class<?>[] parameterTypes;
                    if (!"cmd".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length < 2 || parameterTypes[1] == GeneratedMessageV3.class || !GeneratedMessageV3.class.isAssignableFrom(parameterTypes[1])) continue;
                    parameterType = parameterTypes[1];
                    break;
                }
                if (null == parameterType) continue;
                LOGGER.info("{} <=======> {}", (Object)parameterType.getSimpleName(), (Object)handler.getSimpleName());
                CLASS_HANDLE_MAP.put(parameterType, (ICmdHandler)handler.newInstance());
            }
            return CLASS_HANDLE_MAP;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return CLASS_HANDLE_MAP;
        }
    }

    public Map<Class<?>, ICmdHandler<? extends GeneratedMessageV3>> getClassHandleMap(List<ICmdHandler<? extends GeneratedMessageV3>> handlerList) {
        try {
            if (CollectionUtils.isEmpty(handlerList)) {
                return CLASS_HANDLE_MAP;
            }
            for (ICmdHandler<? extends GeneratedMessageV3> handler : handlerList) {
                Class<?> parameterType = null;
                for (Method method : handler.getClass().getDeclaredMethods()) {
                    Class<?>[] parameterTypes;
                    if (!"cmd".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length < 2 || parameterTypes[1] == GeneratedMessageV3.class || !GeneratedMessageV3.class.isAssignableFrom(parameterTypes[1])) continue;
                    parameterType = parameterTypes[1];
                    break;
                }
                if (null == parameterType || CLASS_HANDLE_MAP.containsKey(parameterType)) continue;
                LOGGER.info("{} <=======> {}", (Object)parameterType.getSimpleName(), (Object)handler.getClass().getName());
                CLASS_HANDLE_MAP.put(parameterType, handler);
            }
            return CLASS_HANDLE_MAP;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return CLASS_HANDLE_MAP;
        }
    }

    public ICmdHandler<? extends GeneratedMessageV3> get(Class<?> msgClazz) {
        if (null == msgClazz) {
            return null;
        }
        return CLASS_HANDLE_MAP.get(msgClazz);
    }

    private static class Holder {
        public static final HandleGenMsgRecognizer INSTANCE = new HandleGenMsgRecognizer();

        private Holder() {
        }
    }
}

