/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.msgGenRecognizer;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zopx.square.netty.msgGenRecognizer.HandleGenMsgRecognizer;

public final class ProtoCodeToProtoRecognizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleGenMsgRecognizer.class);
    private static final Map<Integer, GeneratedMessageV3> CODE_CLASS_MAP = new IntObjectHashMap();
    private static final Map<Integer, Integer> MSGCODE_SERVER_TYPE_MAP = new IntObjectHashMap();

    private ProtoCodeToProtoRecognizer() {
    }

    public static ProtoCodeToProtoRecognizer getInstance() {
        return Holder.INSTANCE;
    }

    public void tryInit(Class<?> protocolClazz, Enum<?>[] enumValArray, int serverType) {
        Class<?>[] innerClazzArray;
        if (null == protocolClazz || null == enumValArray || enumValArray.length <= 0) {
            return;
        }
        HashMap<String, Integer> enumNameAndEnumValMap = new HashMap<String, Integer>();
        for (Enum<?> enumVal : enumValArray) {
            if (!(enumVal instanceof Internal.EnumLite) || enumVal.name().equals("_Dummy") || enumVal.name().equals("UNRECOGNIZED")) continue;
            enumNameAndEnumValMap.put(enumVal.name(), ((Internal.EnumLite)enumVal).getNumber());
        }
        for (Class<?> innerClazz : innerClazzArray = protocolClazz.getDeclaredClasses()) {
            String clazzName;
            Integer msgCode;
            if (!GeneratedMessageV3.class.isAssignableFrom(innerClazz) || null == (msgCode = (Integer)enumNameAndEnumValMap.get("_" + (clazzName = innerClazz.getSimpleName())))) continue;
            try {
                Object newMsg = innerClazz.getDeclaredMethod("getDefaultInstance", new Class[0]).invoke(innerClazz, new Object[0]);
                LOGGER.info("\u5173\u8054 {} <==> {}, serverJobType = {}", new Object[]{clazzName, msgCode, serverType});
                CODE_CLASS_MAP.put(msgCode, (GeneratedMessageV3)newMsg);
                MSGCODE_SERVER_TYPE_MAP.put(msgCode, serverType);
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static int getServerJobTypeByMsgCode(int msgCode) {
        if (msgCode < 0) {
            LOGGER.error("\u6839\u636e\u6d88\u606f\u7f16\u53f7\u83b7\u53d6\u670d\u52a1\u5668\u5de5\u4f5c\u7c7b\u578b\u5904\u7406\u5f02\u5e38\uff0c\u5f02\u5e38code\uff1a{}", (Object)msgCode);
            return -1;
        }
        return MSGCODE_SERVER_TYPE_MAP.get(msgCode);
    }

    public int getMsgCodeByClazz(Class<? extends GeneratedMessageV3> clazz) {
        if (null == clazz) {
            LOGGER.error("\u901a\u8fc7messageV3 \u5f97\u5230\u5bf9\u5e94\u7684\u7f16\u7801\u5904\u7406\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
            return -1;
        }
        Optional<Map.Entry> optional = CODE_CLASS_MAP.entrySet().stream().filter(entry -> Objects.equals(((GeneratedMessageV3)entry.getValue()).getClass(), clazz)).findFirst();
        if (optional.isEmpty()) {
            LOGGER.error("\u6d88\u606f\u7f16\u7801\u83b7\u53d6\u5f02\u5e38");
            return -1;
        }
        return (Integer)optional.get().getKey();
    }

    public Message.Builder getClazzByMsgCode(int code) {
        GeneratedMessageV3 messageV3 = CODE_CLASS_MAP.get(code);
        if (null == messageV3) {
            LOGGER.error("\u6d88\u606f\u5bf9\u8c61\u83b7\u53d6\u5f02\u5e38");
            return null;
        }
        return messageV3.newBuilderForType();
    }

    private static class Holder {
        public static final ProtoCodeToProtoRecognizer INSTANCE = new ProtoCodeToProtoRecognizer();

        private Holder() {
        }
    }
}

