/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.util;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.protobuf.GeneratedMessageV3;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import top.zopx.square.netty.configurator.constant.AttributeKeyConstant;

public final class ChannelKit {
    private final List<Channel> EMPTY_LIST;
    private final Multimap<String, Channel> SESSION_MAP;
    private final transient ChannelFutureListener listener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            future.removeListener((GenericFutureListener)this);
            ChannelKit.this.remove(future.channel());
        }
    };

    private ChannelKit() {
        this.EMPTY_LIST = new LinkedList<Channel>();
        this.SESSION_MAP = Multimaps.synchronizedMultimap((Multimap)LinkedListMultimap.create());
    }

    public static ChannelKit getInstance() {
        return Holder.INSTANCE;
    }

    public String getByChannel(Channel channel) {
        return (String)channel.attr(AttributeKeyConstant.USER_ATTR).get();
    }

    public Collection<Channel> getById(String id) {
        return this.SESSION_MAP.get((Object)id);
    }

    public Optional<Channel> getFirstById(String id) {
        return this.getById(id).stream().findFirst();
    }

    public Collection<Channel> getById(String id, Predicate<Channel> predicate) {
        return this.getById(id).stream().filter(predicate).collect(Collectors.toList());
    }

    public Collection<Channel> getById(Channel channel) {
        String id = this.getByChannel(channel);
        if (id != null) {
            return this.SESSION_MAP.get((Object)id);
        }
        return this.EMPTY_LIST;
    }

    public void put(Channel channel) {
        String id = this.getByChannel(channel);
        if (id != null && channel.isActive()) {
            channel.closeFuture().addListener((GenericFutureListener)this.listener);
            this.SESSION_MAP.put((Object)id, (Object)channel);
        }
        if (!channel.isActive()) {
            this.remove(channel);
        }
    }

    public void remove(Channel channel) {
        String id = this.getByChannel(channel);
        if (id != null) {
            this.SESSION_MAP.remove((Object)id, (Object)channel);
            if (CollectionUtils.isEmpty(this.getById(id))) {
                this.SESSION_MAP.removeAll((Object)id);
            }
        }
    }

    public void remove(String key, Predicate<Channel> predicate) {
        this.getById(key).stream().filter(predicate).forEach(this::close);
    }

    public void close(Channel channel) {
        channel.close();
    }

    public void write(Channel channel, GeneratedMessageV3 msg) {
        this.write(channel, msg, Channel::isActive);
    }

    public void write(Channel channel, GeneratedMessageV3 msg, Predicate<Channel> predicate) {
        this.getById(channel).stream().filter(predicate).forEach(client -> this.writeToLoop((Channel)client, msg));
    }

    public void write(String key, GeneratedMessageV3 msg, Predicate<Channel> predicate) {
        this.getById(key, predicate).forEach(client -> this.writeToLoop((Channel)client, msg));
    }

    public void writeToLoop(Channel channel, GeneratedMessageV3 msg) {
        channel.eventLoop().execute(() -> channel.writeAndFlush((Object)msg));
    }

    public void setSessionID(Channel channel) {
        if (null != channel) {
            this.setSessionID(channel, UUID.randomUUID().toString().replace("-", "").toUpperCase(Locale.ROOT));
        }
    }

    public String getSessionID(Channel channel) {
        if (null == channel) {
            return "";
        }
        return (String)channel.attr(AttributeKeyConstant.SESSION_ID).get();
    }

    public void setSessionID(Channel channel, String sessionId) {
        if (null != channel && StringUtils.isNotBlank((CharSequence)sessionId)) {
            channel.attr(AttributeKeyConstant.SESSION_ID).setIfAbsent((Object)sessionId);
        }
    }

    private static class Holder {
        public static final ChannelKit INSTANCE = new ChannelKit();

        private Holder() {
        }
    }
}

