/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CommandLnKit {
    INSTANCE;

    private static final Logger LOGGER;

    public CommandLine create(String[] args, Config ... configs) {
        Options options = new Options();
        for (Config config : configs) {
            options.addRequiredOption(config.getOpt(), config.getLongOpt(), config.isHasArg(), config.getDesc());
        }
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(CommandLnKit.class);
    }

    public static class Config {
        private String opt;
        private String longOpt;
        private String desc;
        private boolean hasArg;

        public Config(String opt, String longOpt, String desc, boolean hasArg) {
            this.opt = opt;
            this.longOpt = longOpt;
            this.desc = desc;
            this.hasArg = hasArg;
        }

        public String getOpt() {
            return this.opt;
        }

        public void setOpt(String opt) {
            this.opt = opt;
        }

        public String getLongOpt() {
            return this.longOpt;
        }

        public void setLongOpt(String longOpt) {
            this.longOpt = longOpt;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public boolean isHasArg() {
            return this.hasArg;
        }

        public void setHasArg(boolean hasArg) {
            this.hasArg = hasArg;
        }
    }
}

