/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.util;

import com.google.protobuf.GeneratedMessageV3;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatcher;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zopx.square.netty.util.ChannelKit;

public enum GroupKit {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Map<String, ChannelGroup> CHANNEL_GROUP_MAP;

    public void create(String groupKey) {
        if (StringUtils.isBlank((CharSequence)groupKey)) {
            return;
        }
        CHANNEL_GROUP_MAP.putIfAbsent(groupKey, (ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE));
    }

    public void add(String groupKey, List<Channel> channels) {
        if (StringUtils.isBlank((CharSequence)groupKey)) {
            LOGGER.error("\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u4e0d\u5904\u7406");
            return;
        }
        ChannelGroup channelGroup = CHANNEL_GROUP_MAP.getOrDefault(groupKey, (ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE));
        channelGroup.addAll(channels);
        CHANNEL_GROUP_MAP.put(groupKey, channelGroup);
    }

    public void remove(String groupKey, List<Channel> channels) {
        if (StringUtils.isBlank((CharSequence)groupKey)) {
            LOGGER.error("\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u4e0d\u5904\u7406");
            return;
        }
        ChannelGroup channelGroup = CHANNEL_GROUP_MAP.get(groupKey);
        if (null == channelGroup) {
            LOGGER.error("\u5f53\u524d\u7fa4\u7ec4Key\uff1a{}\uff0c\u4e0d\u5b58\u5728", (Object)groupKey);
            return;
        }
        channels.forEach(arg_0 -> channelGroup.remove(arg_0));
    }

    public void remove(String groupKey) {
        if (StringUtils.isBlank((CharSequence)groupKey)) {
            LOGGER.error("\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u4e0d\u5904\u7406");
            return;
        }
        CHANNEL_GROUP_MAP.remove(groupKey);
    }

    public void write(String groupKey, GeneratedMessageV3 msg) {
        if (StringUtils.isBlank((CharSequence)groupKey) || null == msg) {
            LOGGER.error("\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u4e0d\u5904\u7406");
            return;
        }
        ChannelGroup channelGroup = CHANNEL_GROUP_MAP.get(groupKey);
        if (null == channelGroup) {
            LOGGER.error("\u5f53\u524d\u7fa4\u7ec4Key\uff1a{}\uff0c\u4e0d\u5b58\u5728", (Object)groupKey);
            return;
        }
        channelGroup.writeAndFlush((Object)msg);
    }

    public void write(String groupKey, GeneratedMessageV3 msg, List<String> channelKeys) {
        if (StringUtils.isBlank((CharSequence)groupKey) || null == msg) {
            LOGGER.error("\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u4e0d\u5904\u7406");
            return;
        }
        ChannelGroup channelGroup = CHANNEL_GROUP_MAP.get(groupKey);
        if (null == channelGroup) {
            LOGGER.error("\u5f53\u524d\u7fa4\u7ec4Key\uff1a{}\uff0c\u4e0d\u5b58\u5728", (Object)groupKey);
            return;
        }
        ArrayList list = new ArrayList();
        channelKeys.forEach(channelKey -> ChannelKit.getInstance().getById((String)channelKey, Channel::isActive).forEach(channel -> list.add(ChannelMatchers.is((Channel)channel))));
        channelGroup.writeAndFlush((Object)msg, ChannelMatchers.compose((ChannelMatcher[])list.toArray(new ChannelMatcher[0])));
    }

    static {
        LOGGER = LoggerFactory.getLogger(GroupKit.class);
        CHANNEL_GROUP_MAP = new ConcurrentHashMap<String, ChannelGroup>(128);
    }
}

