/*
 * Decompiled with CFR 0.152.
 */
package top.zopx.square.netty.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum PackageUtil {
    INSTANCE;

    private final Map<String, List<Class<?>>> TYPE_MAP = new WeakHashMap(8);

    public List<Class<?>> getFileList(String packageName, Class<?> superClass, boolean isRecursion) throws IOException, ClassNotFoundException {
        if (null == superClass || StringUtils.isBlank((CharSequence)packageName)) {
            return Collections.emptyList();
        }
        return this.getFileListBySuperClass(packageName, isRecursion, superClass::isAssignableFrom);
    }

    public List<Class<?>> getFileListBySuperClass(String packageName, boolean isRecursion, Function<Class<?>, Boolean> func) throws IOException, ClassNotFoundException {
        List<Class<?>> classList = Collections.emptyList();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        Enumeration<URL> enumeration = loader.getResources(packagePath);
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                classList = this.list2Dir(new File(url.getFile()), packageName, isRecursion, func);
                continue;
            }
            if (!"jar".equalsIgnoreCase(protocol)) continue;
            String fileStr = url.getFile();
            if (fileStr.startsWith("file:")) {
                fileStr = fileStr.substring(5);
            }
            if (fileStr.lastIndexOf(33) > 0) {
                fileStr = fileStr.substring(0, fileStr.lastIndexOf(33));
            }
            classList = this.listClazzFromJar(new File(fileStr), packageName, isRecursion, func);
        }
        return classList;
    }

    private List<Class<?>> listClazzFromJar(File file, String packageName, boolean isRecursion, Function<Class<?>, Boolean> filter) throws IOException, ClassNotFoundException {
        if (file == null || file.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList resultList = new ArrayList();
        try (JarInputStream jarIn = new JarInputStream(new FileInputStream(file));){
            JarEntry entry;
            while ((entry = jarIn.getNextJarEntry()) != null) {
                String entryName;
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                if (!isRecursion) {
                    String tmpStr = entryName.substring(0, entryName.lastIndexOf(File.separator));
                    if (!packageName.equals(tmpStr = PackageUtil.join(tmpStr.split(File.separator), "."))) continue;
                }
                String clazzName = entryName.substring(0, entryName.lastIndexOf(46));
                clazzName = PackageUtil.join(clazzName.split(File.separator), ".");
                Class<?> clazzObj = Class.forName(clazzName);
                if (null != filter && !filter.apply(clazzObj).booleanValue()) continue;
                resultList.add(clazzObj);
            }
        }
        return resultList;
    }

    private static String join(String[] strArr, String conn) {
        if (null == strArr || strArr.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strArr.length; ++i) {
            if (i > 0) {
                sb.append(conn);
            }
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    private List<Class<?>> list2Dir(File dirFile, String packageName, boolean isRecursion, Function<Class<?>, Boolean> filter) throws ClassNotFoundException {
        List<Class<?>> resultList = Collections.emptyList();
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return resultList;
        }
        Object[] subFiles = dirFile.listFiles();
        if (null == subFiles || ArrayUtils.isEmpty((Object[])subFiles)) {
            return resultList;
        }
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>(Arrays.asList(subFiles));
        resultList = new ArrayList(queue.size());
        while (!queue.isEmpty()) {
            File poll = (File)queue.poll();
            if (poll.isDirectory() && isRecursion) {
                subFiles = poll.listFiles();
                if (null == subFiles || ArrayUtils.isEmpty((Object[])subFiles)) continue;
                queue.addAll(Arrays.asList(subFiles));
            }
            if (!poll.isFile() || !poll.getName().endsWith(".class")) continue;
            Object clazzName = poll.getAbsolutePath();
            clazzName = ((String)clazzName).substring(dirFile.getAbsolutePath().length(), ((String)clazzName).lastIndexOf("."));
            clazzName = ((String)clazzName).replace("\\", ".");
            clazzName = packageName + (String)clazzName;
            Class<?> returnClass = Class.forName((String)clazzName);
            if (null != filter && !filter.apply(returnClass).booleanValue()) continue;
            resultList.add(returnClass);
        }
        return resultList;
    }

    public boolean isModifier(Class<?> clazz, int modifiers) {
        if (null == clazz) {
            return false;
        }
        return (clazz.getModifiers() & modifiers) != 0;
    }

    public List<Class<?>> getType(Class<?> superClass, String methodName, Function<Class<?>, Boolean> filter) {
        if (null == superClass || StringUtils.isBlank((CharSequence)methodName)) {
            return Collections.emptyList();
        }
        List<Class<?>> cacheList = this.TYPE_MAP.get(methodName);
        if (CollectionUtils.isNotEmpty(cacheList)) {
            return cacheList;
        }
        Object[] methods = superClass.getDeclaredMethods();
        if (ArrayUtils.isEmpty((Object[])methods)) {
            return Collections.emptyList();
        }
        ArrayList returnList = new ArrayList();
        for (Object method : methods) {
            Class<?>[] types;
            if (!((Method)method).getName().equals(methodName)) continue;
            for (Class<?> type : types = ((Method)method).getParameterTypes()) {
                if (null != filter && !filter.apply(type).booleanValue()) continue;
                returnList.add(type);
            }
        }
        if (CollectionUtils.isNotEmpty(returnList)) {
            this.TYPE_MAP.put(methodName, returnList);
        }
        return returnList;
    }
}

