/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.DynamicSellerList;

@ApiModel(description="Paginated search for travel inventory.")
@JsonPropertyOrder(value={"list", "page", "size"})
public class DynamicSellerListRequest {
    public static final String JSON_PROPERTY_LIST = "list";
    private DynamicSellerList _list;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 25;

    public DynamicSellerListRequest _list(DynamicSellerList _list) {
        this._list = _list;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DynamicSellerList getList() {
        return this._list;
    }

    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setList(DynamicSellerList _list) {
        this._list = _list;
    }

    public DynamicSellerListRequest page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Which page to view out of total search results.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public DynamicSellerListRequest size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=50L)
    @ApiModelProperty(example="25", required=true, value="How many result set to return at the time.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=50L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicSellerListRequest dynamicSellerListRequest = (DynamicSellerListRequest)o;
        return Objects.equals(this._list, dynamicSellerListRequest._list) && Objects.equals(this.page, dynamicSellerListRequest.page) && Objects.equals(this.size, dynamicSellerListRequest.size);
    }

    public int hashCode() {
        return Objects.hash(this._list, this.page, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamicSellerListRequest {\n");
        sb.append("    _list: ").append(this.toIndentedString(this._list)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

