/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"identifier", "name", "ownerName", "ownerIdentifier", "clientId", "secretKey", "redirectUris", "roles", "subType", "domains"})
public class Engine {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
    private String secretKey;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
    private List<String> redirectUris = null;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = null;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    private List<String> domains = null;

    public Engine identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique engine record identifier.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public Engine name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Engine 1", value="Name of this engine application. The first engine for every integrator will have the same name as its company name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Engine ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Travel Tech 1", value="Name of company owner.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Engine ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique owner record identifier")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public Engine clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="client-id-123", value="Client identifier used to authenticate an Oauth2 or web component request.")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Engine secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Password used to authenticate an Oauth2 request.")
    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Engine redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public Engine addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"https://my.travel.blog\"]", value="Where to redirect after web components successfully authenticate. For OAuth2 purposes.")
    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public Engine roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public Engine addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"ROLE_ENGINE\"]", value="System roles given this engine application.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Engine subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TRAVELIKO", value="Type of owner that create this record.")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public Engine domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public Engine addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Engine engine = (Engine)o;
        return Objects.equals(this.identifier, engine.identifier) && Objects.equals(this.name, engine.name) && Objects.equals(this.ownerName, engine.ownerName) && Objects.equals(this.ownerIdentifier, engine.ownerIdentifier) && Objects.equals(this.clientId, engine.clientId) && Objects.equals(this.secretKey, engine.secretKey) && Objects.equals(this.redirectUris, engine.redirectUris) && Objects.equals(this.roles, engine.roles) && Objects.equals((Object)this.subType, (Object)engine.subType) && Objects.equals(this.domains, engine.domains);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.ownerName, this.ownerIdentifier, this.clientId, this.secretKey, this.redirectUris, this.roles, this.subType, this.domains});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Engine {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secretKey: ").append(this.toIndentedString(this.secretKey)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

