/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.MoneySetInternalTotal;
import travel.wink.sdk.affiliate.model.MoneySetSourceTotal;
import travel.wink.sdk.affiliate.model.MoneySetUserSpecifiedCurrencyTotal;
import travel.wink.sdk.affiliate.model.PackageOffer;

@ApiModel(description="Package offers travelers booked together with the room.")
@JsonPropertyOrder(value={"items", "userSpecifiedCurrencyTotal", "sourceTotal", "internalTotal"})
public class PackageOffers {
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<PackageOffer> items = null;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private MoneySetSourceTotal sourceTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private MoneySetInternalTotal internalTotal;

    public PackageOffers items(List<PackageOffer> items) {
        this.items = items;
        return this;
    }

    public PackageOffers addItemsItem(PackageOffer itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<PackageOffer>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Array of offer items")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PackageOffer> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItems(List<PackageOffer> items) {
        this.items = items;
    }

    public PackageOffers userSpecifiedCurrencyTotal(MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneySetUserSpecifiedCurrencyTotal getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public PackageOffers sourceTotal(MoneySetSourceTotal sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneySetSourceTotal getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(MoneySetSourceTotal sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public PackageOffers internalTotal(MoneySetInternalTotal internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneySetInternalTotal getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(MoneySetInternalTotal internalTotal) {
        this.internalTotal = internalTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageOffers packageOffers = (PackageOffers)o;
        return Objects.equals(this.items, packageOffers.items) && Objects.equals(this.userSpecifiedCurrencyTotal, packageOffers.userSpecifiedCurrencyTotal) && Objects.equals(this.sourceTotal, packageOffers.sourceTotal) && Objects.equals(this.internalTotal, packageOffers.internalTotal);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.userSpecifiedCurrencyTotal, this.sourceTotal, this.internalTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageOffers {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

