/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.2.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.MerchantBookingRequestBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateMerchantBookingRequestBooker
 */
@JsonPropertyOrder({
  CreateMerchantBookingRequestBooker.JSON_PROPERTY_ROOMS,
  CreateMerchantBookingRequestBooker.JSON_PROPERTY_DISPLAY_CURRENCY,
  CreateMerchantBookingRequestBooker.JSON_PROPERTY_DISPLAY_LANGUAGE,
  CreateMerchantBookingRequestBooker.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER
})
@JsonTypeName("CreateMerchantBookingRequest_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:36:27.832341431+07:00[Asia/Bangkok]")
public class CreateMerchantBookingRequestBooker {
  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<MerchantBookingRequestBooker> rooms = new ArrayList<>();

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
  private String displayLanguage = "en";

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public CreateMerchantBookingRequestBooker() {
  }

  public CreateMerchantBookingRequestBooker rooms(List<MerchantBookingRequestBooker> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public CreateMerchantBookingRequestBooker addRoomsItem(MerchantBookingRequestBooker roomsItem) {
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * List of room configuration booking requests. Each entry is a separately booked room.
   * @return rooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<MerchantBookingRequestBooker> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(List<MerchantBookingRequestBooker> rooms) {
    this.rooms = rooms;
  }


  public CreateMerchantBookingRequestBooker displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The desired currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public CreateMerchantBookingRequestBooker displayLanguage(String displayLanguage) {
    
    this.displayLanguage = displayLanguage;
    return this;
  }

   /**
   * The desired language
   * @return displayLanguage
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayLanguage() {
    return displayLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayLanguage(String displayLanguage) {
    this.displayLanguage = displayLanguage;
  }


  public CreateMerchantBookingRequestBooker engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Optionally include the specific configuration used to make the booking. If no identifier is included, it will default to the primary application configuration.
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateMerchantBookingRequestBooker createMerchantBookingRequestBooker = (CreateMerchantBookingRequestBooker) o;
    return Objects.equals(this.rooms, createMerchantBookingRequestBooker.rooms) &&
        Objects.equals(this.displayCurrency, createMerchantBookingRequestBooker.displayCurrency) &&
        Objects.equals(this.displayLanguage, createMerchantBookingRequestBooker.displayLanguage) &&
        Objects.equals(this.engineConfigurationIdentifier, createMerchantBookingRequestBooker.engineConfigurationIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rooms, displayCurrency, displayLanguage, engineConfigurationIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateMerchantBookingRequestBooker {\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    displayLanguage: ").append(toIndentedString(displayLanguage)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

