/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.2.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.model.ContactBooker;
import travel.wink.sdk.booking.model.PetInfoDtoBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Detailed customer information for this profile
 */
@JsonPropertyOrder({
  PersonalBooker.JSON_PROPERTY_GENDER,
  PersonalBooker.JSON_PROPERTY_BIRTH_DATE,
  PersonalBooker.JSON_PROPERTY_MARITAL_STATUS,
  PersonalBooker.JSON_PROPERTY_CHILD_QUANTITY,
  PersonalBooker.JSON_PROPERTY_CITIZENSHIP,
  PersonalBooker.JSON_PROPERTY_ADDRESS1,
  PersonalBooker.JSON_PROPERTY_ADDRESS2,
  PersonalBooker.JSON_PROPERTY_CITY,
  PersonalBooker.JSON_PROPERTY_POSTAL_CODE,
  PersonalBooker.JSON_PROPERTY_COUNTRY,
  PersonalBooker.JSON_PROPERTY_PREFERRED_CURRENCY,
  PersonalBooker.JSON_PROPERTY_LANGUAGE,
  PersonalBooker.JSON_PROPERTY_CONTACT_PERSON,
  PersonalBooker.JSON_PROPERTY_PHYS_CHALL_NAME,
  PersonalBooker.JSON_PROPERTY_PET_INFO
})
@JsonTypeName("Personal_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:36:27.832341431+07:00[Asia/Bangkok]")
public class PersonalBooker {
  /**
   * Identifier the gender of the customer.
   */
  public enum GenderEnum {
    MALE("MALE"),
    
    FEMALE("FEMALE"),
    
    OTHER("OTHER");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  private GenderEnum gender;

  public static final String JSON_PROPERTY_BIRTH_DATE = "birthDate";
  private LocalDate birthDate;

  /**
   * Marital status of the traveler.
   */
  public enum MaritalStatusEnum {
    ANNULLED("ANNULLED"),
    
    COHABITATING("COHABITATING"),
    
    DIVORCED("DIVORCED"),
    
    ENGAGED("ENGAGED"),
    
    MARRIED("MARRIED"),
    
    SEPARATED("SEPARATED"),
    
    SINGLE("SINGLE"),
    
    WIDOWED("WIDOWED"),
    
    UNKNOWN("UNKNOWN");

    private String value;

    MaritalStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MaritalStatusEnum fromValue(String value) {
      for (MaritalStatusEnum b : MaritalStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MARITAL_STATUS = "maritalStatus";
  private MaritalStatusEnum maritalStatus;

  public static final String JSON_PROPERTY_CHILD_QUANTITY = "childQuantity";
  private Integer childQuantity;

  public static final String JSON_PROPERTY_CITIZENSHIP = "citizenship";
  private String citizenship;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_PREFERRED_CURRENCY = "preferredCurrency";
  private String preferredCurrency;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CONTACT_PERSON = "contactPerson";
  private List<ContactBooker> contactPerson = new ArrayList<>();

  public static final String JSON_PROPERTY_PHYS_CHALL_NAME = "physChallName";
  private List<String> physChallName = new ArrayList<>();

  public static final String JSON_PROPERTY_PET_INFO = "petInfo";
  private List<PetInfoDtoBooker> petInfo = new ArrayList<>();

  public PersonalBooker() {
  }

  public PersonalBooker gender(GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

   /**
   * Identifier the gender of the customer.
   * @return gender
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }


  public PersonalBooker birthDate(LocalDate birthDate) {
    
    this.birthDate = birthDate;
    return this;
  }

   /**
   * Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
   * @return birthDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBirthDate() {
    return birthDate;
  }


  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthDate(LocalDate birthDate) {
    this.birthDate = birthDate;
  }


  public PersonalBooker maritalStatus(MaritalStatusEnum maritalStatus) {
    
    this.maritalStatus = maritalStatus;
    return this;
  }

   /**
   * Marital status of the traveler.
   * @return maritalStatus
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MaritalStatusEnum getMaritalStatus() {
    return maritalStatus;
  }


  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaritalStatus(MaritalStatusEnum maritalStatus) {
    this.maritalStatus = maritalStatus;
  }


  public PersonalBooker childQuantity(Integer childQuantity) {
    
    this.childQuantity = childQuantity;
    return this;
  }

   /**
   * The number of children of the customer.
   * @return childQuantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildQuantity() {
    return childQuantity;
  }


  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildQuantity(Integer childQuantity) {
    this.childQuantity = childQuantity;
  }


  public PersonalBooker citizenship(String citizenship) {
    
    this.citizenship = citizenship;
    return this;
  }

   /**
   * Name of the (self-professed) country that is clamided for citizenship.
   * @return citizenship
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCitizenship() {
    return citizenship;
  }


  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCitizenship(String citizenship) {
    this.citizenship = citizenship;
  }


  public PersonalBooker address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Address line 1
   * @return address1
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public PersonalBooker address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Address line 2
   * @return address2
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public PersonalBooker city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * City
   * @return city
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public PersonalBooker postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal code
   * @return postalCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public PersonalBooker country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public PersonalBooker preferredCurrency(String preferredCurrency) {
    
    this.preferredCurrency = preferredCurrency;
    return this;
  }

   /**
   * Type of funds preferred for reviewing monetary values, in ISO 4217 codes
   * @return preferredCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreferredCurrency() {
    return preferredCurrency;
  }


  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferredCurrency(String preferredCurrency) {
    this.preferredCurrency = preferredCurrency;
  }


  public PersonalBooker language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * The primary language of the customer
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public PersonalBooker contactPerson(List<ContactBooker> contactPerson) {
    
    this.contactPerson = contactPerson;
    return this;
  }

  public PersonalBooker addContactPersonItem(ContactBooker contactPersonItem) {
    if (this.contactPerson == null) {
      this.contactPerson = new ArrayList<>();
    }
    this.contactPerson.add(contactPersonItem);
    return this;
  }

   /**
   * Get contactPerson
   * @return contactPerson
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContactBooker> getContactPerson() {
    return contactPerson;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactPerson(List<ContactBooker> contactPerson) {
    this.contactPerson = contactPerson;
  }


  public PersonalBooker physChallName(List<String> physChallName) {
    
    this.physChallName = physChallName;
    return this;
  }

  public PersonalBooker addPhysChallNameItem(String physChallNameItem) {
    if (this.physChallName == null) {
      this.physChallName = new ArrayList<>();
    }
    this.physChallName.add(physChallNameItem);
    return this;
  }

   /**
   * Get physChallName
   * @return physChallName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPhysChallName() {
    return physChallName;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChallName(List<String> physChallName) {
    this.physChallName = physChallName;
  }


  public PersonalBooker petInfo(List<PetInfoDtoBooker> petInfo) {
    
    this.petInfo = petInfo;
    return this;
  }

  public PersonalBooker addPetInfoItem(PetInfoDtoBooker petInfoItem) {
    if (this.petInfo == null) {
      this.petInfo = new ArrayList<>();
    }
    this.petInfo.add(petInfoItem);
    return this;
  }

   /**
   * Get petInfo
   * @return petInfo
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PetInfoDtoBooker> getPetInfo() {
    return petInfo;
  }


  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetInfo(List<PetInfoDtoBooker> petInfo) {
    this.petInfo = petInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PersonalBooker personalBooker = (PersonalBooker) o;
    return Objects.equals(this.gender, personalBooker.gender) &&
        Objects.equals(this.birthDate, personalBooker.birthDate) &&
        Objects.equals(this.maritalStatus, personalBooker.maritalStatus) &&
        Objects.equals(this.childQuantity, personalBooker.childQuantity) &&
        Objects.equals(this.citizenship, personalBooker.citizenship) &&
        Objects.equals(this.address1, personalBooker.address1) &&
        Objects.equals(this.address2, personalBooker.address2) &&
        Objects.equals(this.city, personalBooker.city) &&
        Objects.equals(this.postalCode, personalBooker.postalCode) &&
        Objects.equals(this.country, personalBooker.country) &&
        Objects.equals(this.preferredCurrency, personalBooker.preferredCurrency) &&
        Objects.equals(this.language, personalBooker.language) &&
        Objects.equals(this.contactPerson, personalBooker.contactPerson) &&
        Objects.equals(this.physChallName, personalBooker.physChallName) &&
        Objects.equals(this.petInfo, personalBooker.petInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(gender, birthDate, maritalStatus, childQuantity, citizenship, address1, address2, city, postalCode, country, preferredCurrency, language, contactPerson, physChallName, petInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PersonalBooker {\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    birthDate: ").append(toIndentedString(birthDate)).append("\n");
    sb.append("    maritalStatus: ").append(toIndentedString(maritalStatus)).append("\n");
    sb.append("    childQuantity: ").append(toIndentedString(childQuantity)).append("\n");
    sb.append("    citizenship: ").append(toIndentedString(citizenship)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    preferredCurrency: ").append(toIndentedString(preferredCurrency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    contactPerson: ").append(toIndentedString(contactPerson)).append("\n");
    sb.append("    physChallName: ").append(toIndentedString(physChallName)).append("\n");
    sb.append("    petInfo: ").append(toIndentedString(petInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

