/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.AncillaryRequestBooker;
import travel.wink.sdk.booking.model.BookingUserRequestBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;

@JsonPropertyOrder(value={"hotelIdentifier", "startDate", "endDate", "roomConfiguration", "promotionalCodes", "roomRateIdentifier", "bedroomConfigurationIdentifier", "ancillaries", "specialRequests", "user", "traceId", "paymentIdentifier"})
@JsonTypeName(value="MerchantBookingRequest_Booker")
public class MerchantBookingRequestBooker {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
    private RoomConfigurationBooker roomConfiguration;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    private UUID roomRateIdentifier;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER = "bedroomConfigurationIdentifier";
    private String bedroomConfigurationIdentifier;
    public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
    private List<AncillaryRequestBooker> ancillaries = new ArrayList<AncillaryRequestBooker>();
    public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
    private String specialRequests;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserRequestBooker user;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_PAYMENT_IDENTIFIER = "paymentIdentifier";
    private String paymentIdentifier;

    public MerchantBookingRequestBooker hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public MerchantBookingRequestBooker startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public MerchantBookingRequestBooker endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public MerchantBookingRequestBooker roomConfiguration(RoomConfigurationBooker roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfigurationBooker getRoomConfiguration() {
        return this.roomConfiguration;
    }

    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomConfiguration(RoomConfigurationBooker roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
    }

    public MerchantBookingRequestBooker promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public MerchantBookingRequestBooker addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public MerchantBookingRequestBooker roomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public MerchantBookingRequestBooker bedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
        this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="bedroomConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBedroomConfigurationIdentifier() {
        return this.bedroomConfigurationIdentifier;
    }

    @JsonProperty(value="bedroomConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
        this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
    }

    public MerchantBookingRequestBooker ancillaries(List<AncillaryRequestBooker> ancillaries) {
        this.ancillaries = ancillaries;
        return this;
    }

    public MerchantBookingRequestBooker addAncillariesItem(AncillaryRequestBooker ancillariesItem) {
        if (this.ancillaries == null) {
            this.ancillaries = new ArrayList<AncillaryRequestBooker>();
        }
        this.ancillaries.add(ancillariesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AncillaryRequestBooker> getAncillaries() {
        return this.ancillaries;
    }

    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAncillaries(List<AncillaryRequestBooker> ancillaries) {
        this.ancillaries = ancillaries;
    }

    public MerchantBookingRequestBooker specialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
        return this;
    }

    @Nullable
    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecialRequests() {
        return this.specialRequests;
    }

    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public MerchantBookingRequestBooker user(BookingUserRequestBooker user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserRequestBooker getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserRequestBooker user) {
        this.user = user;
    }

    public MerchantBookingRequestBooker traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public MerchantBookingRequestBooker paymentIdentifier(String paymentIdentifier) {
        this.paymentIdentifier = paymentIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="paymentIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentIdentifier() {
        return this.paymentIdentifier;
    }

    @JsonProperty(value="paymentIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentIdentifier(String paymentIdentifier) {
        this.paymentIdentifier = paymentIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantBookingRequestBooker merchantBookingRequestBooker = (MerchantBookingRequestBooker)o;
        return Objects.equals(this.hotelIdentifier, merchantBookingRequestBooker.hotelIdentifier) && Objects.equals(this.startDate, merchantBookingRequestBooker.startDate) && Objects.equals(this.endDate, merchantBookingRequestBooker.endDate) && Objects.equals(this.roomConfiguration, merchantBookingRequestBooker.roomConfiguration) && Objects.equals(this.promotionalCodes, merchantBookingRequestBooker.promotionalCodes) && Objects.equals(this.roomRateIdentifier, merchantBookingRequestBooker.roomRateIdentifier) && Objects.equals(this.bedroomConfigurationIdentifier, merchantBookingRequestBooker.bedroomConfigurationIdentifier) && Objects.equals(this.ancillaries, merchantBookingRequestBooker.ancillaries) && Objects.equals(this.specialRequests, merchantBookingRequestBooker.specialRequests) && Objects.equals(this.user, merchantBookingRequestBooker.user) && Objects.equals(this.traceId, merchantBookingRequestBooker.traceId) && Objects.equals(this.paymentIdentifier, merchantBookingRequestBooker.paymentIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.startDate, this.endDate, this.roomConfiguration, this.promotionalCodes, this.roomRateIdentifier, this.bedroomConfigurationIdentifier, this.ancillaries, this.specialRequests, this.user, this.traceId, this.paymentIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantBookingRequestBooker {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfiguration: ").append(this.toIndentedString(this.roomConfiguration)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    bedroomConfigurationIdentifier: ").append(this.toIndentedString(this.bedroomConfigurationIdentifier)).append("\n");
        sb.append("    ancillaries: ").append(this.toIndentedString(this.ancillaries)).append("\n");
        sb.append("    specialRequests: ").append(this.toIndentedString(this.specialRequests)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    paymentIdentifier: ").append(this.toIndentedString(this.paymentIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

