/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.booking.model.BookingUserBooker;
import travel.wink.sdk.booking.model.CustomMonetaryAmountBooker;
import travel.wink.sdk.booking.model.ItineraryBooker;
import travel.wink.sdk.booking.model.RawBeneficiaryBooker;
import travel.wink.sdk.booking.model.RawDailyRateBooker;
import travel.wink.sdk.booking.model.SupplierContractItemPolicyBooker;

@JsonPropertyOrder(value={"user", "nameInEnglish", "descriptionInEnglish", "price", "itinerary", "pricingType", "type", "perUseQuantity", "beneficiaryList", "payable", "policy", "externalIdentifier", "dailyRateList", "totalPrice"})
@JsonTypeName(value="RawSupplierContractItem_Booker")
public class RawSupplierContractItemBooker {
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserBooker user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_PRICE = "price";
    private CustomMonetaryAmountBooker price;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private ItineraryBooker itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PER_USE_QUANTITY = "perUseQuantity";
    private Integer perUseQuantity;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<RawBeneficiaryBooker> beneficiaryList = new ArrayList<RawBeneficiaryBooker>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicyBooker policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<RawDailyRateBooker> dailyRateList = new ArrayList<RawDailyRateBooker>();
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private CustomMonetaryAmountBooker totalPrice;

    public RawSupplierContractItemBooker user(BookingUserBooker user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserBooker getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserBooker user) {
        this.user = user;
    }

    public RawSupplierContractItemBooker nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public RawSupplierContractItemBooker descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public RawSupplierContractItemBooker price(CustomMonetaryAmountBooker price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmountBooker getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(CustomMonetaryAmountBooker price) {
        this.price = price;
    }

    public RawSupplierContractItemBooker itinerary(ItineraryBooker itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ItineraryBooker getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(ItineraryBooker itinerary) {
        this.itinerary = itinerary;
    }

    public RawSupplierContractItemBooker pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public RawSupplierContractItemBooker type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RawSupplierContractItemBooker perUseQuantity(Integer perUseQuantity) {
        this.perUseQuantity = perUseQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="perUseQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerUseQuantity() {
        return this.perUseQuantity;
    }

    @JsonProperty(value="perUseQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerUseQuantity(Integer perUseQuantity) {
        this.perUseQuantity = perUseQuantity;
    }

    public RawSupplierContractItemBooker beneficiaryList(List<RawBeneficiaryBooker> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public RawSupplierContractItemBooker addBeneficiaryListItem(RawBeneficiaryBooker beneficiaryListItem) {
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawBeneficiaryBooker> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<RawBeneficiaryBooker> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public RawSupplierContractItemBooker payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public RawSupplierContractItemBooker policy(SupplierContractItemPolicyBooker policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicyBooker getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicyBooker policy) {
        this.policy = policy;
    }

    public RawSupplierContractItemBooker externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public RawSupplierContractItemBooker dailyRateList(List<RawDailyRateBooker> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public RawSupplierContractItemBooker addDailyRateListItem(RawDailyRateBooker dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<RawDailyRateBooker>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RawDailyRateBooker> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<RawDailyRateBooker> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public RawSupplierContractItemBooker totalPrice(CustomMonetaryAmountBooker totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmountBooker getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(CustomMonetaryAmountBooker totalPrice) {
        this.totalPrice = totalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawSupplierContractItemBooker rawSupplierContractItemBooker = (RawSupplierContractItemBooker)o;
        return Objects.equals(this.user, rawSupplierContractItemBooker.user) && Objects.equals(this.nameInEnglish, rawSupplierContractItemBooker.nameInEnglish) && Objects.equals(this.descriptionInEnglish, rawSupplierContractItemBooker.descriptionInEnglish) && Objects.equals(this.price, rawSupplierContractItemBooker.price) && Objects.equals(this.itinerary, rawSupplierContractItemBooker.itinerary) && Objects.equals((Object)this.pricingType, (Object)rawSupplierContractItemBooker.pricingType) && Objects.equals((Object)this.type, (Object)rawSupplierContractItemBooker.type) && Objects.equals(this.perUseQuantity, rawSupplierContractItemBooker.perUseQuantity) && Objects.equals(this.beneficiaryList, rawSupplierContractItemBooker.beneficiaryList) && Objects.equals((Object)this.payable, (Object)rawSupplierContractItemBooker.payable) && Objects.equals(this.policy, rawSupplierContractItemBooker.policy) && Objects.equals(this.externalIdentifier, rawSupplierContractItemBooker.externalIdentifier) && Objects.equals(this.dailyRateList, rawSupplierContractItemBooker.dailyRateList) && Objects.equals(this.totalPrice, rawSupplierContractItemBooker.totalPrice);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.nameInEnglish, this.descriptionInEnglish, this.price, this.itinerary, this.pricingType, this.type, this.perUseQuantity, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.dailyRateList, this.totalPrice});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawSupplierContractItemBooker {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    perUseQuantity: ").append(this.toIndentedString(this.perUseQuantity)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

