/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.ReviewAnswerOptionAgent;

@JsonPropertyOrder(value={"identifier", "questionIdentifier", "category", "sort", "answer"})
@JsonTypeName(value="ReviewAnswer_Agent")
public class ReviewAnswerAgent {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_QUESTION_IDENTIFIER = "questionIdentifier";
    private UUID questionIdentifier;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_ANSWER = "answer";
    private ReviewAnswerOptionAgent answer;

    public ReviewAnswerAgent identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public ReviewAnswerAgent questionIdentifier(UUID questionIdentifier) {
        this.questionIdentifier = questionIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="questionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getQuestionIdentifier() {
        return this.questionIdentifier;
    }

    @JsonProperty(value="questionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuestionIdentifier(UUID questionIdentifier) {
        this.questionIdentifier = questionIdentifier;
    }

    public ReviewAnswerAgent category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public ReviewAnswerAgent sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public ReviewAnswerAgent answer(ReviewAnswerOptionAgent answer) {
        this.answer = answer;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReviewAnswerOptionAgent getAnswer() {
        return this.answer;
    }

    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAnswer(ReviewAnswerOptionAgent answer) {
        this.answer = answer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewAnswerAgent reviewAnswerAgent = (ReviewAnswerAgent)o;
        return Objects.equals(this.identifier, reviewAnswerAgent.identifier) && Objects.equals(this.questionIdentifier, reviewAnswerAgent.questionIdentifier) && Objects.equals((Object)this.category, (Object)reviewAnswerAgent.category) && Objects.equals(this.sort, reviewAnswerAgent.sort) && Objects.equals(this.answer, reviewAnswerAgent.answer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.questionIdentifier, this.category, this.sort, this.answer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReviewAnswerAgent {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    questionIdentifier: ").append(this.toIndentedString(this.questionIdentifier)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        COMFORT("COMFORT"),
        CONDITION("CONDITION"),
        SERVICE("SERVICE"),
        ENVIRONMENT("ENVIRONMENT"),
        FACILITIES("FACILITIES"),
        LOCATION("LOCATION"),
        LIFESTYLE("LIFESTYLE"),
        VALUE("VALUE"),
        FOOD("FOOD");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

