/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.fflauncher.ConversionToolParameterReference;
import tv.hd3g.fflauncher.IORuntimeException;
import tv.hd3g.fflauncher.OutputFilePresencePolicy;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.CapturedStdOutErrToPrintStream;
import tv.hd3g.processlauncher.ExecutionCallbacker;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.tool.ExecutableTool;

public class ConversionTool
implements ExecutableTool {
    private static Logger log = LogManager.getLogger();
    private static final Predicate<LineEntry> ignoreAllLinesEventsToDisplay = le -> false;
    protected final String execName;
    protected final List<ConversionToolParameterReference> inputSources;
    protected final List<ConversionToolParameterReference> outputExpectedDestinations;
    private final LinkedHashMap<String, String> parametersVariables;
    private File workingDirectory;
    private long maxExecTimeMs;
    private ScheduledExecutorService maxExecTimeScheduler;
    private boolean removeParamsIfNoVarToInject;
    protected final Parameters parameters;
    private boolean onErrorDeleteOutFiles;
    private boolean checkSourcesBeforeReady;
    private Optional<Predicate<LineEntry>> filterForLinesEventsToDisplay;

    public ConversionTool(String execName) {
        this(execName, new Parameters());
    }

    protected ConversionTool(String execName, Parameters parameters) {
        this.execName = Objects.requireNonNull(execName, "\"execName\" can't to be null");
        this.parameters = Objects.requireNonNull(parameters, "\"parameters\" can't to be null");
        this.maxExecTimeMs = 5000L;
        this.inputSources = new ArrayList<ConversionToolParameterReference>();
        this.outputExpectedDestinations = new ArrayList<ConversionToolParameterReference>();
        this.parametersVariables = new LinkedHashMap();
        this.checkSourcesBeforeReady = true;
        this.filterForLinesEventsToDisplay = Optional.of(ignoreAllLinesEventsToDisplay);
    }

    public boolean isRemoveParamsIfNoVarToInject() {
        return this.removeParamsIfNoVarToInject;
    }

    public ConversionTool setRemoveParamsIfNoVarToInject(boolean remove_params_if_no_var_to_inject) {
        this.removeParamsIfNoVarToInject = remove_params_if_no_var_to_inject;
        return this;
    }

    public ConversionTool setMaxExecutionTimeForShortCommands(long max_exec_time, TimeUnit unit) {
        this.maxExecTimeMs = unit.toMillis(max_exec_time);
        return this;
    }

    public ConversionTool setMaxExecTimeScheduler(ScheduledExecutorService maxExecTimeScheduler) {
        this.maxExecTimeScheduler = maxExecTimeScheduler;
        return this;
    }

    public long getMaxExecTime(TimeUnit unit) {
        return unit.convert(this.maxExecTimeMs, TimeUnit.MILLISECONDS);
    }

    public ScheduledExecutorService getMaxExecTimeScheduler() {
        return this.maxExecTimeScheduler;
    }

    public ConversionTool setFilterForLinesEventsToDisplay(Predicate<LineEntry> filterForLinesEventsToDisplay) {
        this.filterForLinesEventsToDisplay = Optional.ofNullable(filterForLinesEventsToDisplay);
        return this;
    }

    public Optional<Predicate<LineEntry>> getFilterForLinesEventsToDisplay() {
        return this.filterForLinesEventsToDisplay;
    }

    public Map<String, String> getParametersVariables() {
        return this.parametersVariables;
    }

    public ConversionTool addInputSource(String source, String varNameInParameters, String ... parametersBeforeInputSource) {
        if (parametersBeforeInputSource != null) {
            return this.addInputSource(source, varNameInParameters, (Collection<String>)Arrays.stream(parametersBeforeInputSource).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()), Collections.emptyList());
        }
        return this.addInputSource(source, varNameInParameters, Collections.emptyList(), Collections.emptyList());
    }

    public ConversionTool addInputSource(File source, String varNameInParameters, String ... parametersBeforeInputSource) {
        if (parametersBeforeInputSource != null) {
            return this.addInputSource(source, varNameInParameters, (Collection<String>)Arrays.stream(parametersBeforeInputSource).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()), Collections.emptyList());
        }
        return this.addInputSource(source, varNameInParameters, Collections.emptyList(), Collections.emptyList());
    }

    public ConversionTool addInputSource(String source, String varNameInParameters, Collection<String> parametersBeforeInputSource, Collection<String> parametersAfterInputSource) {
        this.inputSources.add(new ConversionToolParameterReference(source, varNameInParameters, parametersBeforeInputSource, parametersAfterInputSource));
        return this;
    }

    public ConversionTool addInputSource(File source, String varNameInParameters, Collection<String> parametersBeforeInputSource, Collection<String> parametersAfterInputSource) {
        this.inputSources.add(new ConversionToolParameterReference(source, varNameInParameters, parametersBeforeInputSource, parametersAfterInputSource));
        return this;
    }

    public ConversionTool addOutputDestination(String destination, String varNameInParameters, String ... parametersBeforeOutputDestination) {
        if (parametersBeforeOutputDestination != null) {
            return this.addOutputDestination(destination, varNameInParameters, (Collection<String>)Arrays.stream(parametersBeforeOutputDestination).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()), Collections.emptyList());
        }
        return this.addOutputDestination(destination, varNameInParameters, Collections.emptyList(), Collections.emptyList());
    }

    public ConversionTool addOutputDestination(File destination, String varNameInParameters, String ... parametersBeforeOutputDestination) {
        if (parametersBeforeOutputDestination != null) {
            return this.addOutputDestination(destination, varNameInParameters, (Collection<String>)Arrays.stream(parametersBeforeOutputDestination).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()), Collections.emptyList());
        }
        return this.addOutputDestination(destination, varNameInParameters, Collections.emptyList(), Collections.emptyList());
    }

    public ConversionTool addOutputDestination(String destination, String varNameInParameters, Collection<String> parametersBeforeOutputDestination, Collection<String> parametersAfterOutputDestination) {
        this.outputExpectedDestinations.add(new ConversionToolParameterReference(destination, varNameInParameters, parametersBeforeOutputDestination, parametersAfterOutputDestination));
        return this;
    }

    public ConversionTool addOutputDestination(File destination, String varNameInParameters, Collection<String> parametersBeforeOutputDestination, Collection<String> parametersAfterOutputDestination) {
        this.outputExpectedDestinations.add(new ConversionToolParameterReference(destination, varNameInParameters, parametersBeforeOutputDestination, parametersAfterOutputDestination));
        return this;
    }

    protected void onMissingInputOutputVar(String var_name, String ressource) {
        log.warn("Missing I/O variable \"{}\" in command line \"{}\". Ressource \"{}\" will be ignored", (Object)var_name, (Object)this.getInternalParameters(), (Object)ressource);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ConversionTool setWorkingDirectory(File workingDirectory) throws IOException {
        if (workingDirectory == null) {
            throw new NullPointerException("\"workingDirectory\" can't to be null");
        }
        if (!workingDirectory.exists()) {
            throw new FileNotFoundException("\"" + workingDirectory.getPath() + "\" in filesytem");
        }
        if (!workingDirectory.canRead()) {
            throw new IOException("Can't read workingDirectory \"" + workingDirectory.getPath() + "\"");
        }
        if (!workingDirectory.isDirectory()) {
            throw new FileNotFoundException("\"" + workingDirectory.getPath() + "\" is not a directory");
        }
        this.workingDirectory = workingDirectory;
        return this;
    }

    public boolean isOnErrorDeleteOutFiles() {
        return this.onErrorDeleteOutFiles;
    }

    public ConversionTool setOnErrorDeleteOutFiles(boolean onErrorDeleteOutFiles) {
        this.onErrorDeleteOutFiles = onErrorDeleteOutFiles;
        return this;
    }

    public void beforeRun(ProcesslauncherBuilder processBuilder) {
        if (this.maxExecTimeScheduler != null) {
            processBuilder.setExecutionTimeLimiter(this.maxExecTimeMs, TimeUnit.MILLISECONDS, this.maxExecTimeScheduler);
        }
        if (this.workingDirectory != null) {
            try {
                processBuilder.setWorkingDirectory(this.workingDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.onErrorDeleteOutFiles) {
            processBuilder.addExecutionCallbacker(new ExecutionCallbacker(){

                public void onEndExecution(ProcesslauncherLifecycle processlauncherLifecycle) {
                    if (!processlauncherLifecycle.isCorrectlyDone()) {
                        log.warn("Error during execution of \"{}\", remove output files", (Object)processlauncherLifecycle);
                        ConversionTool.this.cleanUpOutputFiles(true, true);
                    }
                }
            });
        }
        this.filterForLinesEventsToDisplay.filter(ffletd -> !ignoreAllLinesEventsToDisplay.equals(ffletd)).ifPresent(filter -> {
            CapturedStdOutErrToPrintStream psOut = new CapturedStdOutErrToPrintStream(this.getStdOutPrintStreamToDisplayLinesEvents(), this.getStdErrPrintStreamToDisplayLinesEvents());
            psOut.setFilter(filter);
            processBuilder.getSetCaptureStandardOutputAsOutputText().addObserver((CapturedStdOutErrText)psOut);
        });
    }

    protected PrintStream getStdOutPrintStreamToDisplayLinesEvents() {
        return System.out;
    }

    protected PrintStream getStdErrPrintStreamToDisplayLinesEvents() {
        return System.err;
    }

    public Optional<String> getDeclaredSourceByVarName(String var_name) {
        return this.inputSources.stream().filter(paramRef -> paramRef.isVarNameInParametersEquals(var_name)).map(ConversionToolParameterReference::getRessource).findFirst();
    }

    public Optional<String> getDeclaredDestinationByVarName(String var_name) {
        return this.outputExpectedDestinations.stream().filter(paramRef -> paramRef.isVarNameInParametersEquals(var_name)).map(ConversionToolParameterReference::getRessource).findFirst();
    }

    public List<String> getDeclaredSources() {
        return this.inputSources.stream().map(ConversionToolParameterReference::getRessource).collect(Collectors.toUnmodifiableList());
    }

    public List<String> getDeclaredDestinations() {
        return this.outputExpectedDestinations.stream().map(ConversionToolParameterReference::getRessource).collect(Collectors.toUnmodifiableList());
    }

    public ConversionTool addSimpleOutputDestination(String destination_name) {
        if (destination_name == null) {
            throw new NullPointerException("\"destination_name\" can't to be null");
        }
        String varname = this.parameters.addVariable("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destination_name, varname, new String[0]);
        return this;
    }

    public ConversionTool addSimpleOutputDestination(File destinationFile) {
        if (destinationFile == null) {
            throw new NullPointerException("\"destinationFile\" can't to be null");
        }
        String varname = this.parameters.addVariable("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationFile, varname, new String[0]);
        return this;
    }

    public List<File> getOutputFiles(OutputFilePresencePolicy filterPolicy) {
        return this.outputExpectedDestinations.stream().map(ConversionToolParameterReference::getRessource).flatMap(ressource -> {
            try {
                URL url = new URL((String)ressource);
                if (url.getProtocol().equals("file")) {
                    return Stream.of(Paths.get(url.toURI()).toFile());
                }
            }
            catch (MalformedURLException e) {
                return Stream.of(new File((String)ressource));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return Stream.empty();
        }).map(file -> {
            if (!file.exists() && this.getWorkingDirectory() != null) {
                return new File(this.getWorkingDirectory().getAbsolutePath() + File.separator + file.getPath());
            }
            return file;
        }).distinct().filter(filterPolicy.filter()).collect(Collectors.toUnmodifiableList());
    }

    public ConversionTool cleanUpOutputFiles(boolean remove_all, boolean clean_output_directories) {
        this.getOutputFiles(OutputFilePresencePolicy.MUST_EXISTS).stream().filter(file -> {
            if (!file.isFile()) {
                return clean_output_directories;
            }
            return !(!remove_all && file.length() > 0L);
        }).filter(file -> {
            if (file.isFile()) {
                log.info("Delete file \"{}\"", file);
                if (!file.delete()) {
                    throw new IORuntimeException("Can't delete file \"" + file + "\"");
                }
                return false;
            }
            return true;
        }).map(File::toPath).flatMap(dirPath -> {
            try {
                return Files.walk(dirPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile);
            }
            catch (IOException e) {
                log.error("Can't access to {}", dirPath, (Object)e);
                return Stream.empty();
            }
        }).forEach(file -> {
            log.info("Delete \"{}\"", file);
            if (!file.delete()) {
                throw new IORuntimeException("Can't delete \"" + file + "\"");
            }
        });
        return this;
    }

    public Parameters getInternalParameters() {
        return this.parameters;
    }

    public ConversionTool setCheckSourcesBeforeReady(boolean checkSourcesBeforeReady) {
        this.checkSourcesBeforeReady = checkSourcesBeforeReady;
        return this;
    }

    public boolean isCheckSourcesBeforeReady() {
        return this.checkSourcesBeforeReady;
    }

    public ConversionTool checkSources() {
        this.inputSources.forEach(s -> {
            try {
                s.checkOpenRessourceAsFile();
            }
            catch (IOException e) {
                throw new IORuntimeException("Can't open file \"" + s + "\" for check reading", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        });
        return this;
    }

    public ConversionTool checkDestinations() {
        this.outputExpectedDestinations.forEach(s -> {
            try {
                s.checkOpenRessourceAsFile();
            }
            catch (IOException e) {
                throw new IORuntimeException("Can't open file \"" + s + "\" for check reading", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        });
        return this;
    }

    public Parameters getReadyToRunParameters() {
        if (this.checkSourcesBeforeReady) {
            this.checkSources();
        }
        HashMap<String, String> allVarsToInject = new HashMap<String, String>(this.parametersVariables);
        Parameters newerParameters = this.parameters.duplicate();
        Stream.concat(this.inputSources.stream(), this.outputExpectedDestinations.stream()).forEach(paramRef -> {
            String var_name = paramRef.getVarNameInParameters();
            boolean done = newerParameters.injectParamsAroundVariable(var_name, paramRef.getParametersListBeforeRef(), paramRef.getParametersListAfterRef());
            if (done) {
                if (allVarsToInject.containsKey(var_name)) {
                    throw new IllegalStateException("Variable collision: \"" + var_name + "\" was already set to \"" + (String)allVarsToInject.get(var_name) + "\" in " + newerParameters);
                }
                allVarsToInject.put(var_name, paramRef.getRessource());
            } else {
                this.onMissingInputOutputVar(var_name, paramRef.getRessource());
            }
        });
        return newerParameters.injectVariables(allVarsToInject, this.removeParamsIfNoVarToInject);
    }

    public String getExecutableName() {
        return this.execName;
    }
}

