/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.processlauncher.cmdline.Parameters;

class ConversionToolParameterReference {
    private static final int TRY_COUNT_TO_OPEN_FILE = 5;
    private static Logger log = LogManager.getLogger();
    private static final Set<OpenOption> openOptionsReadOnly = Set.of(StandardOpenOption.READ);
    private final String ressource;
    private final boolean ressourceAsFile;
    private final String varNameInParameters;
    private final Parameters parametersBeforeRef;
    private final Parameters parametersAfterRef;

    ConversionToolParameterReference(String reference, String varNameInParameters, Collection<String> parametersBeforeRef, Collection<String> parametersAfterRef) {
        this.ressource = Objects.requireNonNull(reference, "\"reference\" can't to be null");
        this.varNameInParameters = Objects.requireNonNull(varNameInParameters, "\"var_name_in_parameters\" can't to be null");
        this.parametersBeforeRef = Optional.ofNullable(parametersBeforeRef).map(Parameters::new).orElseGet(Parameters::new);
        this.parametersAfterRef = Optional.ofNullable(parametersAfterRef).map(Parameters::new).orElseGet(Parameters::new);
        this.ressourceAsFile = false;
    }

    ConversionToolParameterReference(File reference, String varNameInParameters, Collection<String> parametersBeforeRef, Collection<String> parametersAfterRef) {
        this.ressource = Objects.requireNonNull(reference, "\"reference\" can't to be null").getPath();
        this.varNameInParameters = Objects.requireNonNull(varNameInParameters, "\"var_name_in_parameters\" can't to be null");
        this.parametersBeforeRef = Optional.ofNullable(parametersBeforeRef).map(Parameters::new).orElseGet(Parameters::new);
        this.parametersAfterRef = Optional.ofNullable(parametersAfterRef).map(Parameters::new).orElseGet(Parameters::new);
        this.ressourceAsFile = true;
    }

    String getRessource() {
        return this.ressource;
    }

    List<String> getParametersListAfterRef() {
        return this.parametersAfterRef.getParameters();
    }

    List<String> getParametersListBeforeRef() {
        return this.parametersBeforeRef.getParameters();
    }

    String getVarNameInParameters() {
        return this.varNameInParameters;
    }

    boolean isVarNameInParametersEquals(String var_name) {
        return this.varNameInParameters.equals(var_name);
    }

    void checkOpenRessourceAsFile() throws IOException, InterruptedException {
        if (!this.ressourceAsFile) {
            return;
        }
        File file = new File(this.ressource);
        if (file.isDirectory()) {
            return;
        }
        for (int pos = 0; pos < 5; ++pos) {
            if (file.canRead()) {
                try (SeekableByteChannel sbc = Files.newByteChannel(file.toPath(), openOptionsReadOnly, new FileAttribute[0]);){
                    log.debug("Successfully open file \"{}\" for check access", (Object)file);
                    return;
                }
                catch (IOException e) {
                    if (pos + 1 == 5) {
                        throw e;
                    }
                    Thread.sleep(10L + (long)(100 * pos));
                    continue;
                }
            }
            if (pos + 1 == 5) {
                throw new IOException("Can't read file \"" + file + "\" for check access");
            }
            Thread.sleep(10L + (long)(100 * pos));
        }
    }

    public String toString() {
        return this.getRessource();
    }
}

