/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.fflauncher.Channel;
import tv.hd3g.fflauncher.FFCodec;
import tv.hd3g.fflauncher.FFDevice;
import tv.hd3g.fflauncher.FFFilter;
import tv.hd3g.fflauncher.FFFormat;
import tv.hd3g.fflauncher.FFPixelFormat;
import tv.hd3g.fflauncher.FFProtocols;
import tv.hd3g.fflauncher.FFVersion;
import tv.hd3g.fflauncher.FFbase;
import tv.hd3g.fflauncher.IORuntimeException;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.Exec;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.tool.ExecutableTool;

public class FFAbout {
    private static final String CUVID = "cuvid";
    private static final Logger log = LogManager.getLogger();
    private final String execName;
    private final ExecutableFinder executableFinder;
    private final ScheduledExecutorService maxExecTimeScheduler;
    private FFVersion version;
    private List<FFCodec> codecs;
    private List<FFFormat> formats;
    private List<FFDevice> devices;
    private Set<String> bitStreamFilters;
    private FFProtocols protocols;
    private List<FFFilter> filters;
    private List<FFPixelFormat> pixelsFormats;
    private Set<String> hardwareAccelerationMethods;
    public static final Map<String, Integer> sample_formats;
    public static final Map<String, List<Channel>> channel_layouts;

    FFAbout(String execName, ExecutableFinder executableFinder, ScheduledExecutorService maxExecTimeScheduler) {
        this.execName = Objects.requireNonNull(execName, "\"execName\" can't to be null");
        this.executableFinder = Objects.requireNonNull(executableFinder, "\"executableFinder\" can't to be null");
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler, "\"maxExecTimeScheduler\" can't to be null");
    }

    private CapturedStdOutErrTextRetention internalRun(String bulkParameters) {
        try {
            FFbase referer = new FFbase(this.execName, new Parameters(bulkParameters));
            referer.setMaxExecTimeScheduler(this.maxExecTimeScheduler);
            return new Exec((ExecutableTool)referer, this.executableFinder).runWaitGetText(null);
        }
        catch (InvalidExecution e) {
            if (log.isDebugEnabled()) {
                log.debug("Can't execute {}, it return: {}", (Object)this.execName, (Object)e.getStdErr());
            }
            throw e;
        }
        catch (IOException e) {
            throw new IORuntimeException("Can't execute " + this.execName, e);
        }
    }

    public synchronized FFVersion getVersion() {
        if (this.version == null) {
            this.version = new FFVersion(this.internalRun("-loglevel quiet -version").getStdouterrLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.version;
    }

    public synchronized List<FFCodec> getCodecs() {
        if (this.codecs == null) {
            this.codecs = FFCodec.parse(this.internalRun("-codecs").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.codecs;
    }

    public synchronized List<FFFormat> getFormats() {
        if (this.formats == null) {
            this.formats = FFFormat.parseFormats(this.internalRun("-formats").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.formats;
    }

    public synchronized List<FFDevice> getDevices() {
        if (this.devices == null) {
            this.devices = FFDevice.parseDevices(this.internalRun("-devices").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.devices;
    }

    static Set<String> parseBSFS(Stream<String> lines) {
        return lines.map(String::trim).filter(line -> !line.toLowerCase().startsWith("Bitstream filters:".toLowerCase())).collect(Collectors.toSet());
    }

    public synchronized Set<String> getBitStreamFilters() {
        if (this.bitStreamFilters == null) {
            this.bitStreamFilters = FFAbout.parseBSFS(this.internalRun("-bsfs").getStdoutLines(false).map(String::trim));
        }
        return this.bitStreamFilters;
    }

    public synchronized FFProtocols getProtocols() {
        if (this.protocols == null) {
            this.protocols = new FFProtocols(this.internalRun("-protocols").getStdouterrLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.protocols;
    }

    public synchronized List<FFFilter> getFilters() {
        if (this.filters == null) {
            this.filters = FFFilter.parseFilters(this.internalRun("-filters").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.filters;
    }

    public synchronized List<FFPixelFormat> getPixelFormats() {
        if (this.pixelsFormats == null) {
            this.pixelsFormats = FFPixelFormat.parsePixelsFormats(this.internalRun("-pix_fmts").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.pixelsFormats;
    }

    static Set<String> parseHWAccelerationMethods(Stream<String> lines) {
        return lines.map(String::trim).filter(line -> !line.toLowerCase().startsWith("Hardware acceleration methods:".toLowerCase())).collect(Collectors.toSet());
    }

    public synchronized Set<String> getAvailableHWAccelerationMethods() {
        if (this.hardwareAccelerationMethods == null) {
            this.hardwareAccelerationMethods = FFAbout.parseHWAccelerationMethods(this.internalRun("-hwaccels").getStdoutLines(false).map(String::trim));
        }
        return this.hardwareAccelerationMethods;
    }

    public boolean isCoderIsAvaliable(String codec_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.name.equalsIgnoreCase(codec_name) && codec.encodingSupported);
    }

    public boolean isDecoderIsAvaliable(String codec_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.name.equalsIgnoreCase(codec_name) && codec.decodingSupported);
    }

    public boolean isFromFormatIsAvaliable(String demuxer_name) {
        return this.getFormats().stream().anyMatch(format -> format.name.equalsIgnoreCase(demuxer_name) && format.demuxing);
    }

    public boolean isToFormatIsAvaliable(String muxer_name) {
        return this.getFormats().stream().anyMatch(format -> format.name.equalsIgnoreCase(muxer_name) && format.muxing);
    }

    public boolean isFilterIsAvaliable(String filter_name) {
        return this.getFilters().stream().anyMatch(filter -> filter.tag.equalsIgnoreCase(filter_name));
    }

    public boolean isCoderEngineIsAvaliable(String engine_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.encodingSupported && codec.encoders.contains(engine_name));
    }

    public boolean isDecoderEngineIsAvaliable(String engine_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.decodingSupported && codec.decoders.contains(engine_name));
    }

    public boolean isNVToolkitIsAvaliable() {
        if (!this.getAvailableHWAccelerationMethods().contains("cuda")) {
            log.debug("(NVIDIA) Cuda is not available in hardware acceleration methods");
            return false;
        }
        if (!this.getAvailableHWAccelerationMethods().contains(CUVID)) {
            log.debug("(NVIDIA) Cuvid is not available in hardware acceleration methods");
            return false;
        }
        List allNvRelatedCodecs = this.getCodecs().stream().filter(c -> !c.decoders.isEmpty() || !c.encoders.isEmpty()).flatMap(c -> Stream.concat(c.decoders.stream(), c.encoders.stream())).distinct().filter(c -> c.contains("nvenc") || c.contains(CUVID)).collect(Collectors.toList());
        if (allNvRelatedCodecs.stream().noneMatch(c -> c.contains("nvenc"))) {
            log.debug("(NVIDIA) nvenc is not available in codec list");
            return false;
        }
        if (allNvRelatedCodecs.stream().noneMatch(c -> c.contains(CUVID))) {
            log.debug("(NVIDIA) cuvid is not available in codec list");
            return false;
        }
        return true;
    }

    public boolean isHardwareNVScalerFilterIsAvaliable() {
        return this.getVersion().configuration.contains("libnpp");
    }

    static {
        HashMap<String, Integer> sf = new HashMap<String, Integer>();
        sf.put("u8", 8);
        sf.put("s16", 16);
        sf.put("s32", 32);
        sf.put("flt", 32);
        sf.put("dbl", 64);
        sf.put("u8p", 8);
        sf.put("s16p", 16);
        sf.put("s32p", 32);
        sf.put("fltp", 32);
        sf.put("dblp", 64);
        sf.put("s64", 64);
        sf.put("s64p", 64);
        sample_formats = Collections.unmodifiableMap(sf);
        HashMap<String, List<Channel>> cl = new HashMap<String, List<Channel>>();
        cl.put("mono           ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FC)));
        cl.put("stereo         ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR)));
        cl.put("2.1            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.LFE)));
        cl.put("3.0            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC)));
        cl.put("3.0(back)      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.BC)));
        cl.put("4.0            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BC)));
        cl.put("quad           ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.BL, Channel.BR)));
        cl.put("quad(side)     ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.SL, Channel.SR)));
        cl.put("3.1            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE)));
        cl.put("5.0            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR)));
        cl.put("5.0(side)      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.SL, Channel.SR)));
        cl.put("4.1            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BC)));
        cl.put("5.1            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR)));
        cl.put("5.1(side)      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.SL, Channel.SR)));
        cl.put("6.0            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BC, Channel.SL, Channel.SR)));
        cl.put("6.0(front)     ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)));
        cl.put("hexagonal      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.BC)));
        cl.put("6.1            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BC, Channel.SL, Channel.SR)));
        cl.put("6.1(back)      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR, Channel.BC)));
        cl.put("6.1(front)     ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.LFE, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)));
        cl.put("7.0            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.SL, Channel.SR)));
        cl.put("7.0(front)     ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)));
        cl.put("7.1            ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR, Channel.SL, Channel.SR)));
        cl.put("7.1(wide)      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR, Channel.FLC, Channel.FRC)));
        cl.put("7.1(wide-side) ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)));
        cl.put("octagonal      ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.BC, Channel.SL, Channel.SR)));
        cl.put("hexadecagonal  ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.BC, Channel.SL, Channel.SR, Channel.TFL, Channel.TFC, Channel.TFR, Channel.TBL, Channel.TBC, Channel.TBR, Channel.WL, Channel.WR)));
        cl.put("downmix        ".trim(), Collections.unmodifiableList(Arrays.asList(Channel.DL, Channel.DR)));
        channel_layouts = Collections.unmodifiableMap(cl);
    }
}

