/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.UnknownFormatException;

public class FFCodec {
    private static final String CAN_T_PARSE_LINE = "Can't parse line: \"";
    public final boolean decodingSupported;
    public final boolean encodingSupported;
    public final CodecType type;
    public final boolean intraFrameOnly;
    public final boolean lossyCompression;
    public final boolean losslessCompression;
    public final Set<String> encoders;
    public final Set<String> decoders;
    public final String name;
    public final String longName;

    static List<FFCodec> parse(List<String> lines) {
        return lines.stream().map(String::trim).filter(line -> !line.toLowerCase().startsWith("codecs:")).filter(line -> !line.startsWith("-------")).filter(line -> line.indexOf(61) == -1).map(FFCodec::new).collect(Collectors.toUnmodifiableList());
    }

    private static CodecType letterToCodecType(String line, char letter) {
        if (letter == 'V') {
            return CodecType.VIDEO;
        }
        if (letter == 'A') {
            return CodecType.AUDIO;
        }
        if (letter == 'S') {
            return CodecType.SUBTITLE;
        }
        if (letter == 'D') {
            return CodecType.DATA;
        }
        throw new UnknownFormatException(CAN_T_PARSE_LINE + line + "\" (missing codec type)");
    }

    private static void negativeToOutOfBoundException(int value, String text) {
        if (value == -1) {
            throw new IndexOutOfBoundsException(text);
        }
    }

    FFCodec(String line) {
        String[] lineBlocs = line.split(" ");
        if (lineBlocs.length < 3) {
            throw new UnknownFormatException(CAN_T_PARSE_LINE + line + "\"");
        }
        this.decodingSupported = lineBlocs[0].charAt(0) == 'D';
        this.encodingSupported = lineBlocs[0].charAt(1) == 'E';
        this.type = FFCodec.letterToCodecType(line, lineBlocs[0].charAt(2));
        this.intraFrameOnly = lineBlocs[0].charAt(3) == 'I';
        this.lossyCompression = lineBlocs[0].charAt(4) == 'L';
        boolean bl = this.losslessCompression = lineBlocs[0].charAt(5) == 'S';
        if (lineBlocs[0].substring(3).chars().noneMatch(i -> i == 73 || i == 76 || i == 83 || i == 46)) {
            throw new UnknownFormatException(CAN_T_PARSE_LINE + line + "\" (invalid ends for codec type)");
        }
        this.name = lineBlocs[1].trim();
        String raw_long_name = Arrays.stream(lineBlocs).filter(lb -> !lb.trim().equals("")).skip(2L).collect(Collectors.joining(" "));
        String parDecoders = "(decoders:";
        int decoders_tag_pos = raw_long_name.indexOf("(decoders:");
        int encoders_tag_pos = raw_long_name.indexOf("(encoders:");
        if (decoders_tag_pos > -1 || encoders_tag_pos > -1) {
            if (decoders_tag_pos > -1) {
                int decoders_tag_end_pos = raw_long_name.indexOf(41, decoders_tag_pos);
                FFCodec.negativeToOutOfBoundException(decoders_tag_end_pos, "Can't found \")\" in \"" + raw_long_name + "\"");
                this.decoders = Collections.unmodifiableSet(Arrays.stream(raw_long_name.substring(decoders_tag_pos + "(decoders:".length(), decoders_tag_end_pos).trim().split(" ")).distinct().collect(Collectors.toSet()));
            } else {
                this.decoders = Collections.emptySet();
            }
            if (encoders_tag_pos > -1) {
                int encoders_tag_end_pos = raw_long_name.indexOf(41, encoders_tag_pos);
                FFCodec.negativeToOutOfBoundException(encoders_tag_end_pos, "Can't found \")\" in \"" + raw_long_name + "\"");
                this.encoders = Collections.unmodifiableSet(Arrays.stream(raw_long_name.substring(encoders_tag_pos + "(decoders:".length(), encoders_tag_end_pos).trim().split(" ")).distinct().collect(Collectors.toSet()));
            } else {
                this.encoders = Collections.emptySet();
            }
            this.longName = FFCodec.extractLongnameFromRawLongName(raw_long_name, decoders_tag_pos, encoders_tag_pos);
        } else {
            this.encoders = Collections.emptySet();
            this.decoders = Collections.emptySet();
            this.longName = raw_long_name;
        }
    }

    private static String extractLongnameFromRawLongName(String raw_long_name, int decoders_tag_pos, int encoders_tag_pos) {
        if (decoders_tag_pos > -1 && encoders_tag_pos > -1) {
            return raw_long_name.substring(0, Math.min(decoders_tag_pos - 1, encoders_tag_pos - 1));
        }
        if (decoders_tag_pos > -1) {
            return raw_long_name.substring(0, decoders_tag_pos - 1);
        }
        return raw_long_name.substring(0, encoders_tag_pos - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.longName);
        sb.append(" [");
        sb.append(this.name);
        sb.append("] ");
        sb.append(this.type.toString().toLowerCase());
        if (this.decodingSupported && this.encodingSupported) {
            sb.append(" encoding and decoding supported");
        } else if (this.decodingSupported) {
            sb.append(" decoding only supported");
        } else {
            sb.append(" encoding only supported");
        }
        if (this.intraFrameOnly) {
            sb.append(", intra frame-only codec");
        }
        if (this.lossyCompression) {
            sb.append(", lossy compression");
        }
        if (this.losslessCompression) {
            sb.append(", lossless compression");
        }
        return sb.toString();
    }

    public static enum CodecType {
        VIDEO,
        AUDIO,
        SUBTITLE,
        DATA;

    }
}

