/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.UnknownFormatException;

public class FFFilter {
    public final String tag;
    public final String longName;
    public final boolean timelineSupport;
    public final boolean sliceThreading;
    public final boolean commandSupport;
    public final ConnectorType sourceConnector;
    public final ConnectorType destConnector;
    public final int sourceConnectorsCount;
    public final int destConnectorsCount;

    static List<FFFilter> parseFilters(List<String> lines) {
        return lines.stream().map(String::trim).filter(line -> !line.toLowerCase().startsWith("Filters:".toLowerCase())).filter(line -> !line.startsWith("---")).filter(line -> line.indexOf(61) == -1).map(FFFilter::new).collect(Collectors.toUnmodifiableList());
    }

    FFFilter(String line) {
        List lineBlocs = Arrays.stream(line.split(" ")).filter(lb -> !lb.trim().equals("")).map(String::trim).collect(Collectors.toUnmodifiableList());
        if (lineBlocs.size() < 4) {
            throw new UnknownFormatException("Can't parse line: \"" + line + "\"");
        }
        this.tag = (String)lineBlocs.get(1);
        this.longName = lineBlocs.stream().filter(lb -> !lb.trim().equals("")).skip(3L).collect(Collectors.joining(" "));
        this.timelineSupport = ((String)lineBlocs.get(0)).contains("T");
        this.sliceThreading = ((String)lineBlocs.get(0)).contains("S");
        this.commandSupport = ((String)lineBlocs.get(0)).contains("C");
        String filter_graph = (String)lineBlocs.get(2);
        int pos = filter_graph.indexOf("->");
        String s_source_connector = filter_graph.substring(0, pos);
        String s_dest_connector = filter_graph.substring(pos + "->".length());
        if (s_source_connector.contains("A")) {
            this.sourceConnector = ConnectorType.AUDIO;
        } else if (s_source_connector.contains("V")) {
            this.sourceConnector = ConnectorType.VIDEO;
        } else if (s_source_connector.contains("N")) {
            this.sourceConnector = ConnectorType.DYNAMIC;
        } else if (s_source_connector.contains("|")) {
            this.sourceConnector = ConnectorType.SOURCE_SINK;
        } else {
            throw new UnknownFormatException("Invalid line : \"" + line + "\", invalid filter_graph sourceConnector");
        }
        if (s_dest_connector.contains("A")) {
            this.destConnector = ConnectorType.AUDIO;
        } else if (s_dest_connector.contains("V")) {
            this.destConnector = ConnectorType.VIDEO;
        } else if (s_dest_connector.contains("N")) {
            this.destConnector = ConnectorType.DYNAMIC;
        } else if (s_dest_connector.contains("|")) {
            this.destConnector = ConnectorType.SOURCE_SINK;
        } else {
            throw new UnknownFormatException("Invalid line : \"" + line + "\", invalid filter_graph sourceConnector");
        }
        this.sourceConnectorsCount = s_source_connector.length();
        this.destConnectorsCount = s_dest_connector.length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.longName);
        sb.append(" [");
        sb.append(this.tag);
        sb.append("] ");
        sb.append(this.sourceConnector.toString().toLowerCase());
        if (this.sourceConnectorsCount > 1) {
            sb.append(" (");
            sb.append(this.sourceConnectorsCount);
            sb.append(")");
        }
        sb.append(" -> ");
        sb.append(this.destConnector.toString().toLowerCase());
        if (this.destConnectorsCount > 1) {
            sb.append(" (");
            sb.append(this.destConnectorsCount);
            sb.append(")");
        }
        if (this.timelineSupport) {
            sb.append(" <timeline support>");
        }
        if (this.sliceThreading) {
            sb.append(" <slice threading>");
        }
        if (this.commandSupport) {
            sb.append(" <command support>");
        }
        return sb.toString();
    }

    public static enum ConnectorType {
        AUDIO,
        VIDEO,
        DYNAMIC,
        SOURCE_SINK;

    }
}

