/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.UnknownFormatException;

public class FFFormat {
    public final boolean demuxing;
    public final boolean muxing;
    public final String name;
    public final Set<String> alternateTags;
    public final String longName;

    static List<FFFormat> parseFormats(List<String> lines) {
        return lines.stream().map(String::trim).filter(line -> !line.toLowerCase().startsWith("File formats:".toLowerCase())).filter(line -> !line.toLowerCase().startsWith("D. = Demuxing supported".toLowerCase())).filter(line -> !line.toLowerCase().startsWith(".E = Muxing supported".toLowerCase())).filter(line -> !line.startsWith("--")).map(FFFormat::new).collect(Collectors.toUnmodifiableList());
    }

    FFFormat(String line) {
        List lineBlocs = Arrays.stream(line.split(" ")).filter(lb -> !lb.trim().equals("")).map(String::trim).collect(Collectors.toUnmodifiableList());
        if (lineBlocs.size() < 2) {
            throw new UnknownFormatException("Can't parse line: \"" + line + "\"");
        }
        this.demuxing = ((String)lineBlocs.get(0)).trim().contains("D");
        this.muxing = ((String)lineBlocs.get(0)).trim().contains("E");
        if (((String)lineBlocs.get(1)).contains(",")) {
            this.name = Arrays.stream(((String)lineBlocs.get(1)).trim().split(",")).findFirst().orElse("");
            this.alternateTags = Collections.unmodifiableSet(Arrays.stream(((String)lineBlocs.get(1)).trim().split(",")).collect(Collectors.toSet()));
        } else {
            this.name = (String)lineBlocs.get(1);
            this.alternateTags = Collections.singleton(this.name);
        }
        this.longName = lineBlocs.stream().filter(lb -> !lb.trim().equals("")).skip(2L).collect(Collectors.joining(" "));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.longName.isBlank()) {
            sb.append(this.longName);
            sb.append(" ");
        }
        sb.append("[");
        sb.append(this.name);
        if (this.alternateTags.size() > 1) {
            sb.append(", ");
            sb.append(this.alternateTags.stream().filter(t -> !t.equals(this.name)).collect(Collectors.joining(", ")));
        }
        sb.append("] ");
        if (this.muxing && this.demuxing) {
            sb.append("muxing and demuxing supported");
        } else if (this.muxing) {
            sb.append("muxing only supported");
        } else {
            sb.append("demuxing only supported");
        }
        return sb.toString();
    }
}

