/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.UnknownFormatException;

public class FFPixelFormat {
    public final boolean supportedInput;
    public final boolean supportedOutput;
    public final boolean hardwareAccelerated;
    public final boolean paletted;
    public final boolean bitstream;
    public final int nbComponents;
    public final int bitsPerPixel;
    public final String tag;

    static List<FFPixelFormat> parsePixelsFormats(List<String> lines) {
        return lines.stream().map(String::trim).filter(line -> !line.toLowerCase().startsWith("Pixel formats:".toLowerCase())).filter(line -> !line.contains("=")).filter(line -> !line.toLowerCase().startsWith("FLAGS".toLowerCase())).filter(line -> !line.startsWith("-----")).map(FFPixelFormat::new).collect(Collectors.toUnmodifiableList());
    }

    FFPixelFormat(String line) {
        List lineBlocs = Arrays.stream(line.split(" ")).filter(lb -> !lb.trim().equals("")).map(String::trim).collect(Collectors.toUnmodifiableList());
        if (lineBlocs.size() != 4) {
            throw new UnknownFormatException("Can't parse line: \"" + line + "\"");
        }
        this.supportedInput = ((String)lineBlocs.get(0)).contains("I");
        this.supportedOutput = ((String)lineBlocs.get(0)).contains("O");
        this.hardwareAccelerated = ((String)lineBlocs.get(0)).contains("H");
        this.paletted = ((String)lineBlocs.get(0)).contains("P");
        this.bitstream = ((String)lineBlocs.get(0)).contains("B");
        this.tag = (String)lineBlocs.get(1);
        this.nbComponents = Integer.parseInt((String)lineBlocs.get(2));
        this.bitsPerPixel = Integer.parseInt((String)lineBlocs.get(3));
    }
}

