/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFAbout;
import tv.hd3g.fflauncher.FFLogLevel;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class FFbase
extends ConversionTool {
    private static final String P_LOGLEVEL = "-loglevel";
    private static final String P_HIDE_BANNER = "-hide_banner";
    private FFAbout about;
    private static final Predicate<String> filterOutErrorLines = rawL -> {
        String l = rawL.trim();
        if (l.startsWith("[")) {
            return true;
        }
        if (l.startsWith("ffmpeg version") || l.startsWith("ffprobe version") || l.startsWith("built with") || l.startsWith("configuration:") || l.startsWith("Press [q]")) {
            return false;
        }
        return !l.startsWith("libavutil") && !l.startsWith("libavcodec") && !l.startsWith("libavformat") && !l.startsWith("libavdevice") && !l.startsWith("libavfilter") && !l.startsWith("libswscale") && !l.startsWith("libswresample") && !l.startsWith("libpostproc");
    };

    public FFbase(String execName, Parameters parameters) {
        super(execName, parameters);
    }

    @Override
    public void beforeRun(ProcesslauncherBuilder processBuilder) {
        super.beforeRun(processBuilder);
        if (processBuilder.getEnvironmentVar("AV_LOG_FORCE_COLOR") == null) {
            processBuilder.setEnvironmentVarIfNotFound("AV_LOG_FORCE_NOCOLOR", "1");
        }
    }

    @Override
    protected PrintStream getStdErrPrintStreamToDisplayLinesEvents() {
        return System.out;
    }

    public FFbase setLogLevel(FFLogLevel level, boolean repeat, boolean display_level) {
        this.parameters.ifHasNotParameter(() -> {
            StringBuilder sb = new StringBuilder();
            if (repeat) {
                sb.append("repeat+");
            }
            if (display_level) {
                sb.append("level+");
            }
            sb.append((Object)level);
            this.parameters.prependParameters(new String[]{P_LOGLEVEL, sb.toString()});
        }, new String[]{P_LOGLEVEL, "-v"});
        return this;
    }

    public boolean isLogLevelSet() {
        return this.parameters.hasParameters(new String[]{P_LOGLEVEL, "-v"});
    }

    public FFbase setHidebanner() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{P_HIDE_BANNER}), new String[]{P_HIDE_BANNER});
        return this;
    }

    public boolean isHidebanner() {
        return this.parameters.hasParameters(new String[]{P_HIDE_BANNER});
    }

    public FFbase setOverwriteOutputFiles() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-y"}), new String[]{"-y"});
        return this;
    }

    public boolean isOverwriteOutputFiles() {
        return this.parameters.hasParameters(new String[]{"-y"});
    }

    public FFbase setNeverOverwriteOutputFiles() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-n"}), new String[]{"-n"});
        return this;
    }

    public boolean isNeverOverwriteOutputFiles() {
        return this.parameters.hasParameters(new String[]{"-n"});
    }

    public FFbase addSimpleInputSource(String sourceName, String ... sourceOptions) {
        if (sourceName == null) {
            throw new NullPointerException("\"sourceName\" can't to be null");
        }
        if (sourceOptions == null) {
            return this.addSimpleInputSource(sourceName, Collections.emptyList());
        }
        return this.addSimpleInputSource(sourceName, Arrays.stream(sourceOptions).collect(Collectors.toUnmodifiableList()));
    }

    public FFbase addSimpleInputSource(File file, String ... sourceOptions) {
        if (file == null) {
            throw new NullPointerException("\"file\" can't to be null");
        }
        if (sourceOptions == null) {
            return this.addSimpleInputSource(file, Collections.emptyList());
        }
        return this.addSimpleInputSource(file, Arrays.stream(sourceOptions).collect(Collectors.toUnmodifiableList()));
    }

    public FFbase addSimpleInputSource(String sourceName, List<String> sourceOptions) {
        if (sourceName == null) {
            throw new NullPointerException("\"sourceName\" can't to be null");
        }
        if (sourceOptions == null) {
            throw new NullPointerException("\"sourceOptions\" can't to be null");
        }
        String varname = this.parameters.addVariable("IN_AUTOMATIC_" + this.inputSources.size());
        this.addInputSource(sourceName, varname, (Collection<String>)Stream.concat(sourceOptions.stream(), Stream.of("-i")).collect(Collectors.toUnmodifiableList()), Collections.emptyList());
        return this;
    }

    public FFbase addSimpleInputSource(File file, List<String> sourceOptions) {
        if (file == null) {
            throw new NullPointerException("\"file\" can't to be null");
        }
        if (sourceOptions == null) {
            throw new NullPointerException("\"sourceOptions\" can't to be null");
        }
        String varname = this.parameters.addVariable("IN_AUTOMATIC_" + this.inputSources.size());
        this.addInputSource(file, varname, (Collection<String>)Stream.concat(sourceOptions.stream(), Stream.of("-i")).collect(Collectors.toUnmodifiableList()), Collections.emptyList());
        return this;
    }

    public synchronized FFAbout getAbout(ExecutableFinder executableFinder) {
        if (this.about == null) {
            ScheduledExecutorService maxExecTimeScheduler = this.getMaxExecTimeScheduler();
            this.about = maxExecTimeScheduler == null ? new FFAbout(this.execName, executableFinder, Executors.newSingleThreadScheduledExecutor()) : new FFAbout(this.execName, executableFinder, maxExecTimeScheduler);
        }
        return this.about;
    }

    public Predicate<String> filterOutErrorLines() {
        return filterOutErrorLines;
    }
}

