/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.processlauncher.cmdline.Parameters;

class ConversionToolParameterReference {
    private static final Logger log = LoggerFactory.getLogger(ConversionToolParameterReference.class);
    private static final int TRY_COUNT_TO_OPEN_FILE = 5;
    private static final Set<OpenOption> openOptionsReadOnly = Set.of(StandardOpenOption.READ);
    private final String ressource;
    private final boolean ressourceAsFile;
    private final String varNameInParameters;
    private final Parameters parametersBeforeRef;

    ConversionToolParameterReference(String reference, String varNameInParameters, Collection<String> parametersBeforeRef) {
        this.ressource = Objects.requireNonNull(reference, "\"reference\" can't to be null");
        this.varNameInParameters = Objects.requireNonNull(varNameInParameters, "\"var_name_in_parameters\" can't to be null");
        this.parametersBeforeRef = Optional.ofNullable(parametersBeforeRef).map(Parameters::of).orElseGet(() -> Parameters.of((String[])new String[0]));
        this.ressourceAsFile = false;
    }

    ConversionToolParameterReference(File reference, String varNameInParameters, Collection<String> parametersBeforeRef) {
        this.ressource = Objects.requireNonNull(reference, "\"reference\" can't to be null").getPath();
        this.varNameInParameters = Objects.requireNonNull(varNameInParameters, "\"var_name_in_parameters\" can't to be null");
        this.parametersBeforeRef = Optional.ofNullable(parametersBeforeRef).map(Parameters::of).orElseGet(() -> Parameters.of((String[])new String[0]));
        this.ressourceAsFile = true;
    }

    String getRessource() {
        return this.ressource;
    }

    Parameters getParametersBeforeRef() {
        return this.parametersBeforeRef;
    }

    void manageCollisionsParameters(Parameters actualParameters) {
        List parametersList = this.parametersBeforeRef.getParameters();
        if (parametersList.isEmpty()) {
            return;
        }
        List actual = actualParameters.getParameters();
        int allNParamBeforeThisVarCount = (int)actual.stream().takeWhile(arg -> !arg.equals(this.varNameInParameters)).count();
        log.trace("Compare collisions, actual: \"{}\", this: \"{}\"", (Object)actual, (Object)parametersList);
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int pos2 = 0; pos2 < Math.min(parametersList.size(), allNParamBeforeThisVarCount); ++pos2) {
            String argActual = (String)actual.get(allNParamBeforeThisVarCount - (pos2 + 1));
            String argThis = (String)parametersList.get(parametersList.size() - (pos2 + 1));
            if (!argThis.equals(argActual)) break;
            toRemove.add(pos2);
        }
        Collections.reverse(toRemove);
        toRemove.forEach(pos -> parametersList.remove((int)pos));
        if (parametersList.isEmpty()) {
            return;
        }
        for (int windowsWidth = 0; windowsWidth < Math.min(parametersList.size(), allNParamBeforeThisVarCount) - 1; ++windowsWidth) {
            List parametersListSubList;
            int actualMinBound = allNParamBeforeThisVarCount - (windowsWidth + 1);
            int actualMaxBound = allNParamBeforeThisVarCount;
            boolean beforePMinBound = false;
            int beforePMaxBound = windowsWidth + 1;
            List actualSubList = actual.subList(actualMinBound, actualMaxBound);
            if (!actualSubList.equals(parametersListSubList = parametersList.subList(0, beforePMaxBound))) continue;
            parametersListSubList.clear();
            break;
        }
    }

    List<String> getParametersListBeforeRef() {
        return this.getParametersBeforeRef().getParameters();
    }

    String getVarNameInParameters() {
        return this.varNameInParameters;
    }

    boolean isVarNameInParametersEquals(String varName) {
        return this.varNameInParameters.equals(varName);
    }

    void checkOpenRessourceAsFile() throws IOException, InterruptedException {
        if (!this.ressourceAsFile) {
            return;
        }
        File file = new File(this.ressource);
        if (file.isDirectory()) {
            return;
        }
        for (int pos = 0; pos < 5; ++pos) {
            if (file.canRead()) {
                try (SeekableByteChannel sbc = Files.newByteChannel(file.toPath(), openOptionsReadOnly, new FileAttribute[0]);){
                    log.debug("Successfully open file \"{}\" for check access", (Object)file);
                    return;
                }
                catch (IOException e) {
                    if (pos + 1 == 5) {
                        throw e;
                    }
                    Thread.sleep(10L + (long)(100 * pos));
                    continue;
                }
            }
            if (pos + 1 == 5) {
                throw new IOException("Can't read file \"" + file + "\" for check access");
            }
            Thread.sleep(10L + (long)(100 * pos));
        }
    }

    public String toString() {
        return this.getRessource();
    }
}

