/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.SimpleSourceTraits;
import tv.hd3g.fflauncher.about.FFAbout;
import tv.hd3g.fflauncher.enums.FFLogLevel;
import tv.hd3g.fflauncher.enums.FilterConnectorType;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.FilterChains;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class FFbase
extends ConversionTool
implements SimpleSourceTraits {
    private static final String IN_AUTOMATIC = "IN_AUTOMATIC_";
    private static final String P_LOGLEVEL = "-loglevel";
    private static final String P_HIDE_BANNER = "-hide_banner";
    private FFAbout about;
    private static final Predicate<String> filterOutErrorLines = rawL -> {
        String l = rawL.trim();
        if (l.startsWith("[")) {
            return true;
        }
        if (l.startsWith("ffmpeg version") || l.startsWith("ffprobe version") || l.startsWith("built with") || l.startsWith("configuration:") || l.startsWith("Press [q]")) {
            return false;
        }
        return !l.startsWith("libavutil") && !l.startsWith("libavcodec") && !l.startsWith("libavformat") && !l.startsWith("libavdevice") && !l.startsWith("libavfilter") && !l.startsWith("libswscale") && !l.startsWith("libswresample") && !l.startsWith("libpostproc");
    };

    public FFbase(String execName, Parameters parameters) {
        super(execName, parameters);
    }

    @Override
    public void beforeRun(ProcesslauncherBuilder processBuilder) {
        super.beforeRun(processBuilder);
        if (processBuilder.getEnvironmentVar("AV_LOG_FORCE_COLOR") == null) {
            processBuilder.setEnvironmentVarIfNotFound("AV_LOG_FORCE_NOCOLOR", "1");
        }
    }

    @Override
    protected PrintStream getStdErrPrintStreamToDisplayLinesEvents() {
        return System.out;
    }

    public FFbase setLogLevel(FFLogLevel level, boolean repeat, boolean display_level) {
        this.parameters.ifHasNotParameter(() -> {
            StringBuilder sb = new StringBuilder();
            if (repeat) {
                sb.append("repeat+");
            }
            if (display_level) {
                sb.append("level+");
            }
            sb.append((Object)level);
            this.parameters.prependParameters(new String[]{P_LOGLEVEL, sb.toString()});
        }, new String[]{P_LOGLEVEL, "-v"});
        return this;
    }

    public boolean isLogLevelSet() {
        return this.parameters.hasParameters(new String[]{P_LOGLEVEL, "-v"});
    }

    public FFbase setHidebanner() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{P_HIDE_BANNER}), new String[]{P_HIDE_BANNER});
        return this;
    }

    public boolean isHidebanner() {
        return this.parameters.hasParameters(new String[]{P_HIDE_BANNER});
    }

    public FFbase setOverwriteOutputFiles() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-y"}), new String[]{"-y"});
        return this;
    }

    public boolean isOverwriteOutputFiles() {
        return this.parameters.hasParameters(new String[]{"-y"});
    }

    public FFbase setNeverOverwriteOutputFiles() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-n"}), new String[]{"-n"});
        return this;
    }

    public boolean isNeverOverwriteOutputFiles() {
        return this.parameters.hasParameters(new String[]{"-n"});
    }

    @Override
    public void addSimpleInputSource(String sourceName, List<String> sourceOptions) {
        Objects.requireNonNull(sourceName, "\"sourceName\" can't to be null");
        Objects.requireNonNull(sourceOptions, "\"sourceOptions\" can't to be null");
        String varname = this.parameters.tagVar(IN_AUTOMATIC + this.inputSources.size());
        this.addVarInParametersIfNotExists(varname);
        this.addInputSource(sourceName, varname, Stream.concat(sourceOptions.stream(), Stream.of("-i")).toList());
    }

    @Override
    public void addSimpleInputSource(File file, List<String> sourceOptions) {
        Objects.requireNonNull(file, "\"file\" can't to be null");
        Objects.requireNonNull(sourceOptions, "\"sourceOptions\" can't to be null");
        String varname = this.parameters.tagVar(IN_AUTOMATIC + this.inputSources.size());
        this.addVarInParametersIfNotExists(varname);
        this.addInputSource(file, varname, Stream.concat(sourceOptions.stream(), Stream.of("-i")).toList());
    }

    private void addVarInParametersIfNotExists(String varname) {
        if (!this.parameters.getParameters().contains(varname)) {
            String defaultInVar = this.parameters.extractVarNameFromTaggedParameter(varname);
            if (defaultInVar.startsWith(IN_AUTOMATIC)) {
                Integer indexInput = Integer.valueOf(defaultInVar.substring(IN_AUTOMATIC.length()));
                if (indexInput > 0) {
                    String expectedPreviousVarName = this.parameters.tagVar(IN_AUTOMATIC + (indexInput - 1));
                    int posInParams = this.parameters.getParameters().indexOf(expectedPreviousVarName);
                    if (posInParams == this.parameters.count() - 1) {
                        this.parameters.addParameters(new String[]{varname});
                    } else {
                        List newList = List.of(this.parameters.getParameters().stream().limit((long)posInParams + 1L), Stream.of(varname), this.parameters.getParameters().stream().skip((long)posInParams + 1L)).stream().flatMap(s -> s).toList();
                        this.parameters.replaceParameters(newList);
                    }
                } else {
                    this.parameters.prependParameters(new String[]{varname});
                }
            } else {
                this.parameters.addParameters(new String[]{varname});
            }
        }
    }

    @Override
    public ConversionTool addSimpleOutputDestination(String destinationName) {
        String varname = this.parameters.tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addVarInParametersIfNotExists(varname);
        return super.addSimpleOutputDestination(destinationName);
    }

    @Override
    public ConversionTool addSimpleOutputDestination(File destinationFile) {
        String varname = this.parameters.tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addVarInParametersIfNotExists(varname);
        return super.addSimpleOutputDestination(destinationFile);
    }

    public synchronized FFAbout getAbout(ExecutableFinder executableFinder) {
        if (this.about == null) {
            ScheduledExecutorService maxExecTimeScheduler = this.getMaxExecTimeScheduler();
            this.about = maxExecTimeScheduler == null ? new FFAbout(this.execName, executableFinder, Executors.newSingleThreadScheduledExecutor()) : new FFAbout(this.execName, executableFinder, maxExecTimeScheduler);
        }
        return this.about;
    }

    public synchronized List<Filter> checkFiltersAvailability(ExecutableFinder executableFinder) {
        this.getAbout(executableFinder);
        List<Filter> badVideoFilters = FilterChains.merge(FilterChains.parse("-vf", this)).checkFiltersAvailability(this.about, FilterConnectorType.VIDEO);
        List<Filter> badAudioFilters = FilterChains.merge(FilterChains.parse("-af", this)).checkFiltersAvailability(this.about, FilterConnectorType.AUDIO);
        List<Filter> badGenericFilterChainsLists = FilterChains.merge(FilterChains.parse("-filter", this)).checkFiltersAvailability(this.about);
        List<Filter> badGenericComplexFilterChainsLists = FilterChains.merge(FilterChains.parse("-filter_complex", this)).checkFiltersAvailability(this.about);
        return Stream.of(badVideoFilters.stream(), badAudioFilters.stream(), badGenericFilterChainsLists.stream(), badGenericComplexFilterChainsLists.stream()).flatMap(s -> s).toList();
    }

    public Predicate<String> filterOutErrorLines() {
        return filterOutErrorLines;
    }
}

