/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ffmpeg.ffprobe.StreamType;
import tv.hd3g.fflauncher.InternalParametersSupplier;
import tv.hd3g.fflauncher.MediaException;
import tv.hd3g.fflauncher.SimpleSourceTraits;
import tv.hd3g.fflauncher.about.FFAbout;
import tv.hd3g.fflauncher.about.FFAboutCodec;
import tv.hd3g.fflauncher.enums.FFHardwareCodec;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;

public interface HardwareProcessTraits
extends InternalParametersSupplier,
SimpleSourceTraits {
    default public int getDeviceIdToUse() {
        return -1;
    }

    default public void addHardwareNVScalerFilter(Point newSize, String pixelFormat, String interpAlgo) {
        StringBuilder scale = new StringBuilder();
        scale.append("scale_npp=");
        scale.append("w=" + newSize.x + ":");
        scale.append("h=" + newSize.y + ":");
        if (pixelFormat != null) {
            scale.append("format=" + pixelFormat + ":");
        }
        if (interpAlgo != null) {
            scale.append("interp_algo=" + interpAlgo);
        }
        this.getInternalParameters().addParameters(new String[]{"-vf", scale.toString()});
    }

    default public void addHardwareNVMultipleScalerFilterComplex(Map<String, String> configuration) {
        Objects.requireNonNull(configuration, "\"configuration\" can't to be null");
        if (configuration.isEmpty()) {
            throw new IllegalArgumentException("\"configuration\" can't to be empty");
        }
        StringBuilder nvresize = new StringBuilder();
        nvresize.append("nvresize=outputs=" + configuration.size() + ":");
        nvresize.append("size=" + configuration.keySet().stream().collect(Collectors.joining("|")) + ":");
        if (this.getDeviceIdToUse() > -1) {
            nvresize.append("gpu=" + this.getDeviceIdToUse() + ":");
        }
        nvresize.append("readback=0" + configuration.keySet().stream().map(configuration::get).collect(Collectors.joining("", "[", "]")));
        this.getInternalParameters().addParameters(new String[]{"-filter_complex", nvresize.toString()});
    }

    default public void addHardwareVideoDecoding(String source, FFprobeJAXB analysingResult, FFHardwareCodec hardwareCodec, FFAbout about) throws MediaException {
        Optional<String> oSourceCuvidCodecEngine;
        Optional oVideoStream = analysingResult.getFirstVideoStream();
        if (!oVideoStream.isPresent()) {
            throw new MediaException("Can't found \"valid\" video stream on \"" + source + "\"");
        }
        StreamType videoStream = (StreamType)oVideoStream.get();
        FFAboutCodec codec = about.getCodecs().stream().filter(c -> c.decodingSupported && c.name.equals(videoStream.getCodecName())).findFirst().orElseThrow(() -> new MediaException("Can't found a valid decoder codec for " + videoStream.getCodecName() + " in \"" + source + "\""));
        if (hardwareCodec == FFHardwareCodec.NV && about.isNVToolkitIsAvaliable() && (oSourceCuvidCodecEngine = codec.decoders.stream().filter(decoder -> decoder.endsWith("_cuvid")).findFirst()).isPresent()) {
            ArrayList<String> sourceOptions = new ArrayList<String>();
            if (this.getDeviceIdToUse() > -1) {
                sourceOptions.add("-hwaccel_device");
                sourceOptions.add(Integer.toString(this.getDeviceIdToUse()));
            }
            sourceOptions.add("-hwaccel");
            sourceOptions.add("cuvid");
            sourceOptions.add("-vsync");
            sourceOptions.add("0");
            sourceOptions.add("-c:v");
            sourceOptions.add(oSourceCuvidCodecEngine.get());
            this.addSimpleInputSource(source, sourceOptions);
        }
        throw new MediaException("Can't found a valid hardware decoder on \"" + source + "\" (\"" + videoStream.getCodecLongName() + "\")");
    }

    default public void addHardwareVideoEncoding(String destCodecName, int outputVideoStreamIndex, FFHardwareCodec hardwareCodec, FFAbout about) throws MediaException {
        if (destCodecName.equals("copy")) {
            throw new MediaException("\"copy\" codec can't be handled by hardware !");
        }
        FFAboutCodec codec = about.getCodecs().stream().filter(c -> c.encodingSupported && c.name.equals(destCodecName)).findFirst().orElseThrow(() -> new MediaException("Can't found a valid codec for " + destCodecName));
        if (hardwareCodec != FFHardwareCodec.NV || !about.isNVToolkitIsAvaliable()) {
            throw new MediaException("Can't found a valid hardware coder to \"" + destCodecName + "\"");
        }
        String coder = codec.encoders.stream().filter(encoder -> encoder.endsWith("_nvenc") || encoder.startsWith("nvenc_") || encoder.equals("nvenc")).findFirst().orElseThrow(() -> new MediaException("Can't found a valid hardware " + hardwareCodec + " codec for " + destCodecName));
        if (outputVideoStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-c:v:" + outputVideoStreamIndex, coder});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-c:v", coder});
        }
    }
}

