/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import tv.hd3g.fflauncher.InternalParametersSupplier;
import tv.hd3g.fflauncher.enums.FFUnit;
import tv.hd3g.fflauncher.enums.Preset;
import tv.hd3g.fflauncher.enums.Tune;

public interface VideoOutputTrait
extends InternalParametersSupplier {
    default public void addPreset(Preset preset) {
        this.getInternalParameters().addParameters(new String[]{"-preset", preset.toString()});
    }

    default public void addTune(Tune tune) {
        this.getInternalParameters().addParameters(new String[]{"-tune", tune.toString()});
    }

    default public void addBitrate(int bitrate, FFUnit bitrateUnit, int outputVideoStreamIndex) {
        if (outputVideoStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-b:v:" + outputVideoStreamIndex, bitrate + bitrateUnit.toString()});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-b:v", bitrate + bitrateUnit.toString()});
        }
    }

    default public void addBitrateControl(int minRate, int maxRate, int bufsize, FFUnit bitrateUnit) {
        if (minRate > 0) {
            this.getInternalParameters().addParameters(new String[]{"-minrate", minRate + bitrateUnit.toString()});
        }
        if (maxRate > 0) {
            this.getInternalParameters().addParameters(new String[]{"-maxrate", maxRate + bitrateUnit.toString()});
        }
        if (bufsize > 0) {
            this.getInternalParameters().addParameters(new String[]{"-bufsize", bufsize + bitrateUnit.toString()});
        }
    }

    default public void addCRF(int crf) {
        this.getInternalParameters().addParameters(new String[]{"-crf", String.valueOf(crf)});
    }

    default public void addVideoCodecName(String codecName, int outputVideoStreamIndex) {
        if (outputVideoStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-c:v:" + outputVideoStreamIndex, codecName});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-c:v", codecName});
        }
    }

    default public void addGOPControl(int b_frames, int gop_size, int ref_frames) {
        if (b_frames > 0) {
            this.getInternalParameters().addParameters(new String[]{"-bf", String.valueOf(b_frames)});
        }
        if (gop_size > 0) {
            this.getInternalParameters().addParameters(new String[]{"-g", String.valueOf(gop_size)});
        }
        if (ref_frames > 0) {
            this.getInternalParameters().addParameters(new String[]{"-ref", String.valueOf(ref_frames)});
        }
    }

    default public void addIBQfactor(float i_qfactor, float b_qfactor) {
        if (i_qfactor > 0.0f) {
            this.getInternalParameters().addParameters(new String[]{"-i_qfactor", String.valueOf(i_qfactor)});
        }
        if (b_qfactor > 0.0f) {
            this.getInternalParameters().addParameters(new String[]{"-b_qfactor", String.valueOf(b_qfactor)});
        }
    }

    default public void addQMinMax(int qmin, int qmax) {
        if (qmin > 0) {
            this.getInternalParameters().addParameters(new String[]{"-qmin", String.valueOf(qmin)});
        }
        if (qmax > 0) {
            this.getInternalParameters().addParameters(new String[]{"-qmax", String.valueOf(qmax)});
        }
    }

    default public void addVsync(int value) {
        this.getInternalParameters().addParameters(new String[]{"-vsync", String.valueOf(value)});
    }
}

