/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.Objects;
import tv.hd3g.fflauncher.acm.ACMExportableMapReference;
import tv.hd3g.fflauncher.enums.ChannelLayout;

abstract class ACMAudioStream
implements ACMExportableMapReference {
    private final ChannelLayout layout;
    private final int fileIndex;
    private final int streamIndex;

    ACMAudioStream(ChannelLayout layout, int fileIndex, int streamIndex) {
        this.layout = Objects.requireNonNull(layout);
        this.fileIndex = fileIndex;
        if (fileIndex < 0) {
            throw new IllegalArgumentException("Invalid negative values: " + fileIndex);
        }
        this.streamIndex = streamIndex;
        if (streamIndex < 0) {
            throw new IllegalArgumentException("Invalid negative values: " + streamIndex);
        }
    }

    int getFileIndex() {
        return this.fileIndex;
    }

    ChannelLayout getLayout() {
        return this.layout;
    }

    int getStreamIndex() {
        return this.streamIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileIndex, this.layout, this.streamIndex});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACMAudioStream other = (ACMAudioStream)obj;
        return this.fileIndex == other.fileIndex && this.layout == other.layout && this.streamIndex == other.streamIndex;
    }
}

