/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tv.hd3g.fflauncher.acm.InputAudioChannelSelector;
import tv.hd3g.fflauncher.acm.InputAudioStream;
import tv.hd3g.fflauncher.acm.OutputAudioStream;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.enums.SourceNotFoundPolicy;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;

public class AudioChannelManipulationSetup {
    static final Pattern extractFromParentheses = Pattern.compile("\\(([^)]+)\\)");
    private List<String> channelMap;
    private List<Integer> outputFileIndexes;
    private SourceNotFoundPolicy notFound;

    public void setChannelMap(List<String> channelMap) {
        this.channelMap = channelMap;
    }

    public List<String> getChannelMap() {
        return this.channelMap;
    }

    public SourceNotFoundPolicy getNotFound() {
        return this.notFound;
    }

    public void setNotFound(SourceNotFoundPolicy notFound) {
        this.notFound = notFound;
    }

    public List<Integer> getOutputFileIndexes() {
        return this.outputFileIndexes;
    }

    public void setOutputFileIndexes(List<Integer> outputFileIndexes) {
        this.outputFileIndexes = outputFileIndexes;
    }

    public List<OutputAudioStream> getAllOutputStreamList(List<FFprobeJAXB> sourcesAnalysis) {
        Objects.requireNonNull(this.channelMap);
        if (this.notFound == null) {
            this.notFound = SourceNotFoundPolicy.ERROR;
        }
        if (this.outputFileIndexes == null) {
            this.outputFileIndexes = List.of();
        }
        if (this.channelMap.isEmpty()) {
            return List.of();
        }
        return new SetupBuilder(sourcesAnalysis).build();
    }

    private class SetupBuilder {
        final List<InputAudioStream> inputStreams;
        final List<OutputAudioStream> outputStreams;
        final HashMap<Integer, Integer> relativeOutStrIdxByOutFileIdx;

        SetupBuilder(List<FFprobeJAXB> sourcesAnalysis) {
            this.inputStreams = InputAudioStream.getListFromAnalysis(sourcesAnalysis);
            this.outputStreams = new ArrayList<OutputAudioStream>();
            this.relativeOutStrIdxByOutFileIdx = new HashMap();
        }

        private void onChannelMapEntry(String entry) {
            new ChannelMap(entry).extractMap();
        }

        List<OutputAudioStream> build() {
            AudioChannelManipulationSetup.this.channelMap.stream().map(entry -> entry.trim().replace(" ", "")).filter(entry -> !entry.isEmpty()).forEach(this::onChannelMapEntry);
            return Collections.unmodifiableList(this.outputStreams);
        }

        private class ChannelMap {
            final String entry;
            final int outputStreamAbsoluteIndex;
            final int outputFileIndex;
            ChannelLayout outputLayout;
            int relativeOutStrmIdx;
            String outputStreamTopologyRaw;

            ChannelMap(String entry) {
                this.entry = entry;
                this.outputStreamAbsoluteIndex = SetupBuilder.this.outputStreams.size();
                this.outputFileIndex = this.outputStreamAbsoluteIndex < AudioChannelManipulationSetup.this.outputFileIndexes.size() ? AudioChannelManipulationSetup.this.outputFileIndexes.get(this.outputStreamAbsoluteIndex) : (AudioChannelManipulationSetup.this.outputFileIndexes.isEmpty() ? 0 : AudioChannelManipulationSetup.this.outputFileIndexes.get(AudioChannelManipulationSetup.this.outputFileIndexes.size() - 1));
            }

            void mapFullStream() {
                int relativeSourceStreamIndex;
                int sourceFileIndex = Integer.parseInt(this.outputStreamTopologyRaw.split(":")[0]);
                InputAudioStream inputAudioStream = InputAudioStream.getFromRelativeIndexes(SetupBuilder.this.inputStreams, sourceFileIndex, relativeSourceStreamIndex = Integer.parseInt(this.outputStreamTopologyRaw.split(":")[1]));
                if (inputAudioStream == null) {
                    this.applySourceNotFoundBehavior("Can't found input channel by file/stream indexes: " + sourceFileIndex + "/" + relativeSourceStreamIndex);
                    return;
                }
                this.outputLayout = Optional.ofNullable(this.outputLayout).orElse(inputAudioStream.getLayout());
                OutputAudioStream outputStream = new OutputAudioStream(this.outputLayout, this.outputFileIndex, this.relativeOutStrmIdx);
                int chSize = inputAudioStream.getLayout().getChannelSize();
                for (int pos = 0; pos < chSize; ++pos) {
                    outputStream.mapChannel(inputAudioStream, new InputAudioChannelSelector(pos));
                }
                SetupBuilder.this.outputStreams.add(outputStream);
            }

            boolean mapSingleSourceAbsoluteChannel(int absoluteInputChannel, List<InputAudioStream.SelectedInputChannel> selectedInputChannels) {
                InputAudioStream.SelectedInputChannel selected = InputAudioStream.getFromAbsoluteIndex(SetupBuilder.this.inputStreams, absoluteInputChannel);
                if (selected == null) {
                    return this.applySourceNotFoundBehavior("Can't found absolute input channel index: " + absoluteInputChannel);
                }
                InputAudioStream inputStream = selected.getInputAudioStream();
                InputAudioChannelSelector channelSelector = selected.getChannelSelector();
                InputAudioStream inputAudioStream = inputStream;
                Objects.requireNonNull(inputAudioStream);
                selectedInputChannels.add(new InputAudioStream.SelectedInputChannel(inputAudioStream, inputStream, channelSelector));
                return false;
            }

            boolean applySourceNotFoundBehavior(String message) {
                if (AudioChannelManipulationSetup.this.notFound == SourceNotFoundPolicy.ERROR) {
                    throw new SourceNotFoundPolicy.SourceNotFoundException(message);
                }
                return AudioChannelManipulationSetup.this.notFound == SourceNotFoundPolicy.REMOVE_OUT_STREAM;
            }

            boolean mapSingleSourceRelativeChannel(String absoluteInputRaw, List<InputAudioStream.SelectedInputChannel> selectedInputChannels) {
                String[] absoluteInput = absoluteInputRaw.split(":");
                if (absoluteInput.length != 3) {
                    throw new IllegalArgumentException("Invalid channel map entry: " + absoluteInputRaw);
                }
                int sourceFileIndex = Integer.parseInt(absoluteInput[0]);
                int relativeSourceStreamIndex = Integer.parseInt(absoluteInput[1]);
                InputAudioChannelSelector channelSelector = new InputAudioChannelSelector(Integer.parseInt(absoluteInput[2]));
                InputAudioStream inputStream = InputAudioStream.getFromRelativeIndexes(SetupBuilder.this.inputStreams, sourceFileIndex, relativeSourceStreamIndex);
                if (inputStream == null) {
                    return this.applySourceNotFoundBehavior("Can't found file/stream index: " + sourceFileIndex + "/" + relativeSourceStreamIndex);
                }
                InputAudioStream inputAudioStream = inputStream;
                Objects.requireNonNull(inputAudioStream);
                selectedInputChannels.add(new InputAudioStream.SelectedInputChannel(inputAudioStream, inputStream, channelSelector));
                return false;
            }

            void mapSingleChannels() {
                ArrayList<InputAudioStream.SelectedInputChannel> selectedInputChannels = new ArrayList<InputAudioStream.SelectedInputChannel>();
                String[] outputChannelTopologyRaw = this.outputStreamTopologyRaw.split("\\+");
                for (int posOutCh = 0; posOutCh < outputChannelTopologyRaw.length; ++posOutCh) {
                    boolean isStop;
                    String absoluteInputRaw = outputChannelTopologyRaw[posOutCh];
                    try {
                        isStop = this.mapSingleSourceAbsoluteChannel(Integer.parseInt(absoluteInputRaw), selectedInputChannels);
                    }
                    catch (NumberFormatException e) {
                        isStop = this.mapSingleSourceRelativeChannel(absoluteInputRaw, selectedInputChannels);
                    }
                    if (!isStop) continue;
                    return;
                }
                if (this.outputLayout == null) {
                    this.outputLayout = ChannelLayout.getByChannelSize(selectedInputChannels.size());
                }
                OutputAudioStream outputStream = new OutputAudioStream(this.outputLayout, this.outputFileIndex, this.relativeOutStrmIdx);
                selectedInputChannels.forEach(selectedInput -> outputStream.mapChannel(selectedInput.getInputAudioStream(), selectedInput.getChannelSelector()));
                SetupBuilder.this.outputStreams.add(outputStream);
            }

            void extractMap() {
                Matcher layoutMatcher = extractFromParentheses.matcher(this.entry);
                if (layoutMatcher.find()) {
                    String rawLayout = layoutMatcher.group();
                    this.outputLayout = ChannelLayout.parse(rawLayout.substring(1, rawLayout.length() - 1));
                }
                this.relativeOutStrmIdx = SetupBuilder.this.relativeOutStrIdxByOutFileIdx.getOrDefault(this.outputFileIndex, -1) + 1;
                SetupBuilder.this.relativeOutStrIdxByOutFileIdx.put(this.outputFileIndex, this.relativeOutStrmIdx);
                this.outputStreamTopologyRaw = layoutMatcher.replaceAll("");
                if (this.outputStreamTopologyRaw.indexOf(43) == -1 && this.outputStreamTopologyRaw.split(":").length == 2) {
                    this.mapFullStream();
                } else {
                    this.mapSingleChannels();
                }
            }
        }
    }
}

