/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import tv.hd3g.fflauncher.acm.ACMAudioStream;
import tv.hd3g.fflauncher.acm.InputAudioChannelSelector;
import tv.hd3g.fflauncher.acm.InputAudioStream;
import tv.hd3g.fflauncher.acm.OutputAudioChannelSelector;
import tv.hd3g.fflauncher.enums.ChannelLayout;

public class OutputAudioStream
extends ACMAudioStream
implements Comparable<OutputAudioStream> {
    private final Set<OutputAudioChannel> channels = new HashSet<OutputAudioChannel>();
    private String mapReference;

    public OutputAudioStream(ChannelLayout layout, int fileIndex, int streamIndex) {
        super(layout, fileIndex, streamIndex);
    }

    Set<OutputAudioChannel> getChannels() {
        return this.channels;
    }

    @Override
    public String toMapReferenceAsInput() {
        return this.mapReference;
    }

    void setMapReference(String mapReference) {
        this.mapReference = mapReference;
    }

    public String toString() {
        String mapRef = Optional.ofNullable(this.toMapReferenceAsInput()).orElse("");
        return this.getFileIndex() + ":" + this.getStreamIndex() + "(" + this.getLayout() + ")" + mapRef;
    }

    void addChannel(OutputAudioChannel channel) {
        this.channels.add(channel);
    }

    @Override
    public int compareTo(OutputAudioStream o) {
        int compareFile = Integer.compare(this.getFileIndex(), o.getFileIndex());
        if (compareFile == 0) {
            return Integer.compare(this.getStreamIndex(), o.getStreamIndex());
        }
        return compareFile;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputAudioStream other = (OutputAudioStream)obj;
        return Objects.equals(this.channels, other.channels) && Objects.equals(this.mapReference, other.mapReference);
    }

    public OutputAudioStream mapChannel(InputAudioStream inputAudioStream, InputAudioChannelSelector chInIndex, OutputAudioChannelSelector chOutIndex) {
        if (this.channels.size() == this.getLayout().getChannelSize()) {
            throw new IllegalArgumentException("Can't add channel in stream, the stream is full (" + this.channels.size() + ") for layout " + this.getLayout());
        }
        OutputAudioChannel created = new OutputAudioChannel(inputAudioStream, chInIndex, this, chOutIndex);
        this.channels.add(created);
        return this;
    }

    public OutputAudioStream mapChannel(InputAudioStream inputAudioStream, InputAudioChannelSelector chInIndex) {
        if (this.channels.size() == this.getLayout().getChannelSize()) {
            throw new IllegalArgumentException("Can't add channel in stream, the stream is full (" + this.channels.size() + ") for layout " + this.getLayout());
        }
        if (chInIndex.getPosInStream() >= inputAudioStream.getLayout().getChannelSize()) {
            throw new IllegalArgumentException("Can't add channel in stream, the selected channel in input stream " + chInIndex.getPosInStream() + " don't exists for layout " + inputAudioStream.getLayout());
        }
        OutputAudioChannel created = new OutputAudioChannel(inputAudioStream, chInIndex, this, new OutputAudioChannelSelector(this.channels.size()));
        this.channels.add(created);
        return this;
    }

    class OutputAudioChannel
    implements Comparable<OutputAudioChannel> {
        private final InputAudioStream inputAudioStream;
        private final InputAudioChannelSelector chInIndex;
        private final OutputAudioStream outputAudioStream;
        private final OutputAudioChannelSelector chOutIndex;

        OutputAudioChannel(InputAudioStream inputAudioStream, InputAudioChannelSelector chInIndex, OutputAudioStream outputAudioStream, OutputAudioChannelSelector chOutIndex) {
            this.inputAudioStream = Objects.requireNonNull(inputAudioStream);
            this.chInIndex = Objects.requireNonNull(chInIndex);
            int inChSize = inputAudioStream.getLayout().getChannelSize();
            if (chInIndex.getPosInStream() >= inChSize) {
                throw new IllegalArgumentException("Can't found in channel #" + inChSize + " in " + inputAudioStream + " stream");
            }
            this.outputAudioStream = Objects.requireNonNull(outputAudioStream);
            this.chOutIndex = Objects.requireNonNull(chOutIndex);
            int outChSize = outputAudioStream.getLayout().getChannelSize();
            if (chOutIndex.getPosInStream() >= outChSize) {
                throw new IllegalArgumentException("Can't found out channel #" + outChSize + " in " + outputAudioStream + " stream");
            }
        }

        @Override
        public int compareTo(OutputAudioChannel o) {
            int outStreams = this.outputAudioStream.compareTo(o.outputAudioStream);
            if (outStreams == 0) {
                return this.chOutIndex.compareTo(o.chOutIndex);
            }
            return outStreams;
        }

        InputAudioStream getInputAudioStream() {
            return this.inputAudioStream;
        }

        InputAudioChannelSelector getChInIndex() {
            return this.chInIndex;
        }

        OutputAudioStream getOutputAudioStream() {
            return this.outputAudioStream;
        }

        OutputAudioChannelSelector getChOutIndex() {
            return this.chOutIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + Objects.hash(this.chInIndex, this.chOutIndex, this.inputAudioStream, this.outputAudioStream);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OutputAudioChannel other = (OutputAudioChannel)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.chInIndex, other.chInIndex) && Objects.equals(this.chOutIndex, other.chOutIndex) && Objects.equals(this.inputAudioStream, other.inputAudioStream) && Objects.equals(this.outputAudioStream, other.outputAudioStream);
        }

        public String toString() {
            return this.inputAudioStream + "." + this.chInIndex + "->" + this.outputAudioStream + "." + this.chOutIndex;
        }

        protected OutputAudioStream getEnclosingInstance() {
            return OutputAudioStream.this;
        }
    }
}

