/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.enums;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.enums.Channel;

public enum ChannelLayout {
    MONO(List.of(Channel.FC)),
    STEREO(List.of(Channel.FL, Channel.FR)),
    CH2_1(List.of(Channel.FL, Channel.FR, Channel.LFE)),
    CH3_0(List.of(Channel.FL, Channel.FR, Channel.FC)),
    CH3_0_BACK(List.of(Channel.FL, Channel.FR, Channel.BC)),
    CH4_0(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BC)),
    QUAD(List.of(Channel.FL, Channel.FR, Channel.BL, Channel.BR)),
    QUAD_SIDE(List.of(Channel.FL, Channel.FR, Channel.SL, Channel.SR)),
    CH3_1(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE)),
    CH5_0(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR)),
    CH5_0_SIDE(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.SL, Channel.SR)),
    CH4_1(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BC)),
    CH5_1(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR)),
    CH5_1_SIDE(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.SL, Channel.SR)),
    CH6_0(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BC, Channel.SL, Channel.SR)),
    CH6_0_FRONT(List.of(Channel.FL, Channel.FR, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)),
    HEXAGONAL(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.BC)),
    CH6_1(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BC, Channel.SL, Channel.SR)),
    CH6_1_BACK(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR, Channel.BC)),
    CH6_1_FRONT(List.of(Channel.FL, Channel.FR, Channel.LFE, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)),
    CH7_0(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.SL, Channel.SR)),
    CH7_0_FRONT(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)),
    CH7_1(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR, Channel.SL, Channel.SR)),
    CH7_1_WIDE(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.BL, Channel.BR, Channel.FLC, Channel.FRC)),
    CH7_1_WIDE_SIDE(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.LFE, Channel.FLC, Channel.FRC, Channel.SL, Channel.SR)),
    OCTAGONAL(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.BC, Channel.SL, Channel.SR)),
    HEXADECAGONAL(List.of(Channel.FL, Channel.FR, Channel.FC, Channel.BL, Channel.BR, Channel.BC, Channel.SL, Channel.SR, Channel.TFL, Channel.TFC, Channel.TFR, Channel.TBL, Channel.TBC, Channel.TBR, Channel.WL, Channel.WR)),
    DOWNMIX(List.of(Channel.DL, Channel.DR));

    private static final Map<String, ChannelLayout> layoutByName;
    private final List<Channel> channelList;

    public static ChannelLayout parse(String layout) {
        return layoutByName.get(layout.toLowerCase());
    }

    private ChannelLayout(List<Channel> channelList) {
        this.channelList = channelList;
    }

    public List<Channel> getChannelList() {
        return this.channelList;
    }

    public int getChannelSize() {
        return this.getChannelList().size();
    }

    public boolean isMonoLayout() {
        return this.getChannelSize() == 1;
    }

    public static ChannelLayout getByChannelSize(int channelSize) {
        switch (channelSize) {
            case 1: {
                return MONO;
            }
            case 2: {
                return STEREO;
            }
        }
        throw new IllegalArgumentException("Can't assert certainty the channel layout from size " + channelSize);
    }

    public String toString() {
        switch (this) {
            case MONO: {
                return "mono";
            }
            case STEREO: {
                return "stereo";
            }
            case CH2_1: {
                return "2.1";
            }
            case CH3_0: {
                return "3.0";
            }
            case CH3_0_BACK: {
                return "3.0(back)";
            }
            case CH4_0: {
                return "4.0";
            }
            case QUAD: {
                return "quad";
            }
            case QUAD_SIDE: {
                return "quad(side)";
            }
            case CH3_1: {
                return "3.1";
            }
            case CH5_0: {
                return "5.0";
            }
            case CH5_0_SIDE: {
                return "5.0(side)";
            }
            case CH4_1: {
                return "4.1";
            }
            case CH5_1: {
                return "5.1";
            }
            case CH5_1_SIDE: {
                return "5.1(side)";
            }
            case CH6_0: {
                return "6.0";
            }
            case CH6_0_FRONT: {
                return "6.0(front)";
            }
            case HEXAGONAL: {
                return "hexagonal";
            }
            case CH6_1: {
                return "6.1";
            }
            case CH6_1_BACK: {
                return "6.1(back)";
            }
            case CH6_1_FRONT: {
                return "6.1(front)";
            }
            case CH7_0: {
                return "7.0";
            }
            case CH7_0_FRONT: {
                return "7.0(front)";
            }
            case CH7_1: {
                return "7.1";
            }
            case CH7_1_WIDE: {
                return "7.1(wide)";
            }
            case CH7_1_WIDE_SIDE: {
                return "7.1(wide-side)";
            }
            case OCTAGONAL: {
                return "octagonal";
            }
            case HEXADECAGONAL: {
                return "hexadecagonal";
            }
            case DOWNMIX: {
                return "downmix";
            }
        }
        throw new IllegalArgumentException("No channel-layout name");
    }

    static {
        layoutByName = Stream.of(ChannelLayout.values()).collect(Collectors.toUnmodifiableMap(ChannelLayout::toString, cl -> cl));
    }
}

