/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.enums;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Predicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OutputFilePresencePolicy {
    ALL{

        @Override
        public Predicate<File> filter() {
            return f -> true;
        }
    }
    ,
    MUST_EXISTS{

        @Override
        public Predicate<File> filter() {
            return TEST_EXISTS;
        }
    }
    ,
    MUST_BE_A_REGULAR_FILE{

        @Override
        public Predicate<File> filter() {
            return TEST_EXISTS.and(TEST_REGULAR_FILE);
        }
    }
    ,
    NOT_EMPTY{

        @Override
        public Predicate<File> filter() {
            return TEST_EXISTS.and(TEST_REGULAR_DIR.and(TEST_NOT_EMPTY_DIR)).or(TEST_REGULAR_FILE.and(TEST_NOT_EMPTY_FILE));
        }
    };

    private static final Predicate<File> TEST_EXISTS;
    private static final Predicate<File> TEST_REGULAR_FILE;
    private static final Predicate<File> TEST_REGULAR_DIR;
    private static final Predicate<File> TEST_NOT_EMPTY_FILE;
    private static final Predicate<File> TEST_NOT_HIDDEN;
    private static final Predicate<File> TEST_NOT_DOTFILE;
    private static final Predicate<File> TEST_NOT_EMPTY_DIR;

    public abstract Predicate<File> filter();

    static {
        TEST_EXISTS = File::exists;
        TEST_REGULAR_FILE = File::isFile;
        TEST_REGULAR_DIR = File::isDirectory;
        TEST_NOT_EMPTY_FILE = f -> f.length() > 0L;
        TEST_NOT_HIDDEN = f -> !f.isHidden();
        TEST_NOT_DOTFILE = f -> !f.getName().startsWith(".");
        TEST_NOT_EMPTY_DIR = d -> {
            try {
                return Files.list(d.toPath()).map(Path::toFile).anyMatch(TEST_NOT_HIDDEN.and(TEST_NOT_DOTFILE));
            }
            catch (IOException e) {
                return false;
            }
        };
    }
}

